/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.util.Enumeration;
import org.doit.html.Tag;
import org.doit.html.Token;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.FilterException;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.ReplyFilter;
import org.doit.muffin.Request;
import org.doit.muffin.RequestFilter;
import org.doit.muffin.filter.NoThanks;

public class NoThanksFilter
implements ContentFilter,
RequestFilter,
ReplyFilter {
    NoThanks factory;
    Prefs prefs;
    InputObjectStream in;
    OutputObjectStream out;
    Request request;

    public NoThanksFilter(NoThanks noThanks) {
        this.factory = noThanks;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public void filter(Request request) throws FilterException {
        String string = request.getURL();
        String string2 = this.factory.redirect(string);
        if (string2 != null) {
            request.setURL(string2);
            return;
        }
        if (this.factory.isKilled(string)) {
            this.factory.process("Killed: " + string + "\n");
            throw new FilterException("NoThanks URL " + string + " rejected");
        }
    }

    public void filter(Reply reply) throws FilterException {
        String string = reply.getContentType();
        if (string != null && this.factory.killContent(string)) {
            this.factory.process("Killed: " + string + "\n");
            throw new FilterException("NoThanks content-type " + string + " rejected");
        }
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        String string = reply.getContentType();
        return string != null && string.startsWith("text/html");
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    public void run() {
        Thread.currentThread().setName("NoThanks");
        try {
            Object object;
            String string = null;
            boolean bl = false;
            block6: while ((object = this.in.read()) != null) {
                Token token = (Token)object;
                if (bl && token.getType() != 4) continue;
                switch (token.getType()) {
                    case 4: {
                        String string2 = token.toString();
                        bl = this.factory.killComment(string2);
                        if (bl) {
                            this.factory.process("Comment: " + string2 + "\n");
                            break;
                        }
                        if (string != null) continue block6;
                        this.out.write(token);
                        break;
                    }
                    case 2: {
                        boolean bl2 = true;
                        Tag tag = token.createTag();
                        if (string != null) {
                            if (!tag.is(string)) continue block6;
                            string = null;
                            break;
                        }
                        if (this.factory.stripTag(tag.name())) {
                            this.factory.process("Stripped: " + tag.name() + "\n");
                            string = this.factory.stripUntil(tag.name());
                            bl2 = false;
                        }
                        if (bl2 && this.factory.replaceTag(tag.name())) {
                            this.factory.process("Replaced: " + tag.name() + "\n");
                            tag = this.factory.replaceTagWith(tag.name());
                        }
                        if (bl2 && this.factory.checkTagAttributes(tag) && this.factory.processTagAttributes(tag)) {
                            bl2 = false;
                            if (this.factory.hasEnd(tag.name())) {
                                string = "/" + tag.name();
                            }
                        }
                        if (bl2 && this.factory.checkTag(tag.name()) && tag.attributeCount() > 0) {
                            Enumeration enumeration = tag.enumerate();
                            while (enumeration.hasMoreElements()) {
                                String string3;
                                String string4 = (String)enumeration.nextElement();
                                if (!this.factory.checkAttr(string4) || (string3 = tag.get(string4)) == null || !this.factory.isKilled(string3)) continue;
                                if (this.factory.isRequired(tag.name())) {
                                    this.factory.process("Killed: " + string4 + " = " + string3 + "\n");
                                    tag.remove(string4);
                                    continue;
                                }
                                this.factory.process("Killed: " + tag.name() + " with " + string4 + " = " + string3 + "\n");
                                bl2 = false;
                                if (!this.factory.hasEnd(tag.name())) break;
                                string = "/" + tag.name();
                                break;
                            }
                        }
                        if (!bl2) continue block6;
                        token.importTag(tag);
                        this.out.write(token);
                        break;
                    }
                    default: {
                        if (string != null) continue block6;
                        this.out.write(token);
                    }
                }
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

