/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.doit.html.Tag;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.filter.NoThanksFilter;
import org.doit.muffin.filter.NoThanksFrame;

public class NoThanks
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    NoThanksFrame frame;
    MessageArea messages;
    private RE kill;
    private RE comment;
    private RE content;
    private Hashtable strip;
    private Vector redirectPatterns;
    private Vector redirectLocations;
    private Hashtable replace;
    private Hashtable tagattrTags;
    private Hashtable tagattrStrip;
    private Hashtable tagattrRemove;
    private Hashtable tagattrReplace;
    private Hashtable tagattrReplaceValue;
    private StringBuffer killBuffer;
    private StringBuffer commentBuffer;
    private StringBuffer contentBuffer;
    private RE hyperTags;
    private RE hyperAttrs;
    private RE hyperEnd;
    private RE requiredTags;

    public NoThanks() {
        try {
            this.hyperTags = new RE("^(a|img|body|form|iframe|frame|layer|object|applet|area|link|base|head|script|input)$");
            this.hyperAttrs = new RE("^(action|archive|background|base|cite|classdid|codebase|data|href|longdesc|profile|src)$");
            this.hyperEnd = new RE("^(a|body|form|iframe|layer|object|applet|head|script)$");
            this.requiredTags = new RE("^(body|head)$");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        String string = prefs.getUserFile("killfile");
        prefs.putString("NoThanks.killfile", string);
        prefs.putInteger("NoThanks.historySize", 500);
        prefs.setOverride(bl);
        this.messages = new MessageArea(prefs.getInteger("NoThanks.historySize"));
        this.load();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new NoThanksFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        NoThanksFilter noThanksFilter = new NoThanksFilter(this);
        noThanksFilter.setPrefs(this.prefs);
        return noThanksFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    boolean isKilled(String string) {
        if (this.kill == null) {
            return false;
        }
        return this.kill.getMatch(string) != null;
    }

    boolean killComment(String string) {
        if (this.comment == null) {
            return false;
        }
        return this.comment.getMatch(string) != null;
    }

    boolean killContent(String string) {
        if (this.content == null) {
            return false;
        }
        return this.content.getMatch(string) != null;
    }

    boolean stripTag(String string) {
        if (this.strip == null) {
            return false;
        }
        return this.strip.containsKey(string);
    }

    String stripUntil(String string) {
        if (this.strip == null) {
            return null;
        }
        String string2 = (String)this.strip.get(string);
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    boolean replaceTag(String string) {
        if (this.replace == null) {
            return false;
        }
        return this.replace.containsKey(string);
    }

    Tag replaceTagWith(String string) {
        if (this.replace == null) {
            return null;
        }
        return (Tag)this.replace.get(string);
    }

    String redirect(String string) {
        if (this.redirectPatterns == null) {
            return null;
        }
        int n = 0;
        while (n < this.redirectPatterns.size()) {
            RE rE = (RE)this.redirectPatterns.elementAt(n);
            if (rE.getMatch(string) != null) {
                return (String)this.redirectLocations.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    boolean checkTag(String string) {
        return this.hyperTags.getMatch(string) != null;
    }

    boolean checkAttr(String string) {
        return this.hyperAttrs.getMatch(string) != null;
    }

    boolean hasEnd(String string) {
        return this.hyperEnd.getMatch(string) != null;
    }

    boolean isRequired(String string) {
        return this.requiredTags.getMatch(string) != null;
    }

    boolean compare(String string, RE rE) {
        if (string == null) {
            string = "";
        }
        return rE.getMatch(string) != null;
    }

    boolean checkTagAttributes(Tag tag) {
        if (this.tagattrTags == null) {
            return false;
        }
        return this.tagattrTags.containsKey(tag.name());
    }

    /*
     * Unable to fully structure code
     */
    boolean processTagAttributes(Tag var1_1) {
        var2_2 = var1_1.enumerate();
        if (var2_2 != null) ** GOTO lbl37
        return false;
lbl-1000:
        // 1 sources

        {
            var3_3 = (String)var2_2.nextElement();
            var4_4 = String.valueOf(var1_1.name()) + "." + var3_3;
            if (this.tagattrStrip.containsKey(var4_4) && this.compare(var1_1.get(var3_3), (RE)this.tagattrStrip.get(var4_4))) {
                if (this.isRequired(var1_1.name())) {
                    this.process("tagattr removed* " + var3_3 + " from " + var1_1.name() + "\n");
                    var1_1.remove(var3_3);
                } else {
                    this.process("tagattr stripped " + var1_1.toString() + "\n");
                    return true;
                }
            }
            if (this.tagattrRemove.containsKey(var4_4) && this.compare(var1_1.get(var3_3), (RE)this.tagattrRemove.get(var4_4))) {
                this.process("tagattr removed " + var3_3 + " from " + var1_1.name() + "\n");
                var1_1.remove(var3_3);
            }
            if (!this.tagattrReplace.containsKey(var4_4) || var1_1.get(var3_3) == null) continue;
            var5_5 = var1_1.get(var3_3);
            var6_6 = (Vector)this.tagattrReplace.get(var4_4);
            var7_7 = (Vector)this.tagattrReplaceValue.get(var4_4);
            var8_8 = 0;
            while (var8_8 < var6_6.size()) {
                var9_9 = (RE)var6_6.elementAt(var8_8);
                var10_10 = var9_9.getMatch(var5_5);
                if (var10_10 != null) {
                    var11_11 = (String)var7_7.elementAt(var8_8);
                    try {
                        var11_11 = var10_10.substituteInto(var11_11);
                        this.process("tagattr replaced \"" + var5_5 + "\" with \"" + var11_11 + "\"\n");
                        var1_1.put(var3_3, var11_11);
                    }
                    catch (REException var12_12) {
                        System.out.println("REException " + var12_12);
                    }
                }
                ++var8_8;
            }
lbl37:
            // 3 sources

            ** while (var2_2.hasMoreElements())
        }
lbl38:
        // 1 sources

        return false;
    }

    void save() {
        this.manager.save(this);
    }

    RE createRE(Vector vector) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append(vector.elementAt(n));
            if (n != vector.size() - 1) {
                stringBuffer.append("|");
            }
            ++n;
        }
        stringBuffer.append(")");
        return new RE(stringBuffer.toString());
    }

    void load() {
        String string = this.prefs.getUserFile(this.prefs.getString("NoThanks.killfile"));
        try {
            this.load(new FileReader(new File(string)));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void load(Reader reader) {
        this.strip = new Hashtable(33);
        this.redirectPatterns = new Vector();
        this.redirectLocations = new Vector();
        this.replace = new Hashtable(33);
        this.tagattrTags = new Hashtable(33);
        this.tagattrStrip = new Hashtable(33);
        this.tagattrRemove = new Hashtable(33);
        this.tagattrReplace = new Hashtable(33);
        this.tagattrReplaceValue = new Hashtable(33);
        this.killBuffer = new StringBuffer();
        this.commentBuffer = new StringBuffer();
        this.contentBuffer = new StringBuffer();
        this.include(reader);
        try {
            String string;
            this.kill = this.killBuffer.length() > 0 ? new RE("(" + this.killBuffer.toString() + ")") : null;
            this.comment = this.commentBuffer.length() > 0 ? new RE("(" + this.commentBuffer.toString() + ")") : null;
            this.content = this.contentBuffer.length() > 0 ? new RE("(" + this.contentBuffer.toString() + ")") : null;
            Enumeration enumeration = this.tagattrStrip.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.tagattrStrip.put(string, this.createRE((Vector)this.tagattrStrip.get(string)));
            }
            enumeration = this.tagattrRemove.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.tagattrRemove.put(string, this.createRE((Vector)this.tagattrRemove.get(string)));
            }
            return;
        }
        catch (REException rEException) {
            System.out.println("NoThanks REException: " + rEException.getMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void include(Reader reader) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((string = bufferedReader.readLine()) != null) {
                Vector vector;
                String string2;
                Object object;
                String string3;
                StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
                streamTokenizer.resetSyntax();
                streamTokenizer.whitespaceChars(0, 32);
                streamTokenizer.wordChars(33, 126);
                streamTokenizer.quoteChar(34);
                streamTokenizer.eolIsSignificant(true);
                int n = streamTokenizer.nextToken();
                if (n != -3) continue;
                if (streamTokenizer.sval.startsWith("#")) {
                    if (!streamTokenizer.sval.equals("#include")) continue;
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    String string4 = this.prefs.getUserFile(streamTokenizer.sval);
                    this.include(new FileReader(new File(string4)));
                    continue;
                }
                if (streamTokenizer.sval.equals("kill")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    if (this.killBuffer.length() > 0) {
                        this.killBuffer.append("|");
                    }
                    this.killBuffer.append(streamTokenizer.sval);
                    continue;
                }
                if (streamTokenizer.sval.equals("comment")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    if (this.commentBuffer.length() > 0) {
                        this.commentBuffer.append("|");
                    }
                    this.commentBuffer.append(streamTokenizer.sval);
                    continue;
                }
                if (streamTokenizer.sval.equals("strip")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    String string5 = new String(streamTokenizer.sval);
                    string3 = "";
                    n = streamTokenizer.nextToken();
                    if (n == -3 || n == 34) {
                        string3 = new String(streamTokenizer.sval);
                    }
                    this.strip.put(string5.toLowerCase(), string3.toLowerCase());
                    continue;
                }
                if (streamTokenizer.sval.equals("content")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    if (this.contentBuffer.length() > 0) {
                        this.contentBuffer.append("|");
                    }
                    this.contentBuffer.append(streamTokenizer.sval);
                    continue;
                }
                if (streamTokenizer.sval.equals("redirect")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    String string6 = new String(streamTokenizer.sval);
                    string3 = "";
                    n = streamTokenizer.nextToken();
                    if (n == -3 || n == 34) {
                        string3 = new String(streamTokenizer.sval);
                    }
                    try {
                        object = new RE(string6);
                        this.redirectPatterns.addElement(object);
                        this.redirectLocations.addElement(string3);
                    }
                    catch (REException rEException) {
                        System.out.println(String.valueOf(string6) + " " + rEException.getMessage());
                    }
                    continue;
                }
                if (streamTokenizer.sval.equals("replace")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    String string7 = new String(streamTokenizer.sval);
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    string3 = new String(streamTokenizer.sval);
                    object = null;
                    string2 = null;
                    int n2 = string3.indexOf(" \t");
                    if (n2 == -1) {
                        object = string3;
                    } else {
                        object = string3.substring(n2);
                        string2 = string3.substring(n2 + 1);
                    }
                    vector = new Tag((String)object, string2);
                    this.replace.put(string7.toLowerCase(), vector);
                    continue;
                }
                if (streamTokenizer.sval.equals("tagattr")) {
                    Object object2;
                    int n3;
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34 || (n3 = streamTokenizer.sval.indexOf(46)) == -1) break;
                    string3 = streamTokenizer.sval.substring(0, n3);
                    string3 = string3.toLowerCase();
                    object = streamTokenizer.sval.substring(n3 + 1);
                    object = ((String)object).toLowerCase();
                    string2 = String.valueOf(string3) + "." + (String)object;
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    String string8 = new String(streamTokenizer.sval);
                    vector = (Vector)this.tagattrTags.get(string3);
                    if (vector == null) {
                        vector = new Vector();
                        this.tagattrTags.put(string3, vector);
                    }
                    vector.addElement(object);
                    n = streamTokenizer.nextToken();
                    String string9 = n != -3 && n != 34 ? ".*" : new String(streamTokenizer.sval);
                    RE rE = new RE(string9);
                    if (string8.equals("strip")) {
                        if (this.tagattrStrip.containsKey(string2)) {
                            object2 = (Vector)this.tagattrStrip.get(string2);
                        } else {
                            object2 = new Vector();
                            this.tagattrStrip.put(string2, object2);
                        }
                        ((Vector)object2).addElement(string9);
                        continue;
                    }
                    if (string8.equals("remove")) {
                        if (this.tagattrRemove.containsKey(string2)) {
                            object2 = (Vector)this.tagattrRemove.get(string2);
                        } else {
                            object2 = new Vector();
                            this.tagattrRemove.put(string2, object2);
                        }
                        ((Vector)object2).addElement(string9);
                        continue;
                    }
                    if (string8.equals("replace")) {
                        Vector vector2;
                        Vector vector3;
                        n = streamTokenizer.nextToken();
                        if (n != -3 && n != 34) {
                            System.out.println("tagattr replace missing value");
                            break;
                        }
                        object2 = new String(streamTokenizer.sval);
                        if (this.tagattrReplace.containsKey(string2)) {
                            vector3 = (Vector)this.tagattrReplace.get(string2);
                            vector2 = (Vector)this.tagattrReplaceValue.get(string2);
                        } else {
                            vector3 = new Vector();
                            vector2 = new Vector();
                            this.tagattrReplace.put(string2, vector3);
                            this.tagattrReplaceValue.put(string2, vector2);
                        }
                        vector3.addElement(rE);
                        vector2.addElement(object2);
                        continue;
                    }
                    System.out.println("tagattr " + string8 + " unknown command");
                    continue;
                }
                System.out.println("NoThanks: " + streamTokenizer.sval + " unknown command");
            }
            bufferedReader.close();
            return;
        }
        catch (REException rEException) {
            System.out.println("NoThanks REException: " + rEException.getMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void process(String string) {
        this.messages.append(string);
    }
}

