/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import org.doit.html.Tag;
import org.doit.html.Token;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;
import org.doit.muffin.filter.ImageKill;

public class ImageKillFilter
implements ContentFilter {
    ImageKill factory;
    Prefs prefs;
    InputObjectStream in;
    OutputObjectStream out;
    Request request;

    ImageKillFilter(ImageKill imageKill) {
        this.factory = imageKill;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        String string = reply.getContentType();
        return string != null && string.startsWith("text/html");
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    public void run() {
        Thread.currentThread().setName("ImageKill");
        try {
            Object object;
            int n = this.prefs.getInteger("ImageKill.minheight");
            int n2 = this.prefs.getInteger("ImageKill.minwidth");
            int n3 = this.prefs.getInteger("ImageKill.ratio");
            boolean bl = this.prefs.getBoolean("ImageKill.keepmaps");
            while ((object = this.in.read()) != null) {
                Tag tag;
                Token token = (Token)object;
                if (token.getType() == 2 && (tag = token.createTag()).is("img") && tag.has("width") && tag.has("height") && (!bl || !tag.has("usemap")) && !this.factory.isExcluded(tag.get("src"))) {
                    try {
                        int n4;
                        int n5 = Integer.parseInt(tag.get("height"));
                        if (n5 > n && (n4 = Integer.parseInt(tag.get("width"))) > n2 && n4 / n5 > n3) {
                            this.factory.process("tag removed: " + tag + "\n");
                            continue;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.factory.process("malformed image size: " + tag + "\n");
                    }
                }
                this.out.write(token);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

