/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.awt.Component;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.filter.HostnameExpanderFilter;
import org.doit.muffin.filter.HostnameExpanderFrame;

public class HostnameExpander
implements FilterFactory {
    final String[] prefix = new String[]{"www.", "home.", "web.", "http."};
    final String[] suffix = new String[]{".com", ".edu", ".net", ".org"};
    FilterManager manager;
    Prefs prefs;
    HostnameExpanderFrame frame;
    MessageArea messages;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putString("HostnameExpander.defaultDomain", "");
        prefs.putInteger("HostnameExpander.historySize", 500);
        prefs.putStringList("HostnameExpander.prefix", this.prefix);
        prefs.putStringList("HostnameExpander.suffix", this.suffix);
        prefs.setOverride(bl);
        this.messages = new MessageArea(prefs.getInteger("HostnameExpander.historySize"));
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new HostnameExpanderFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        HostnameExpanderFilter hostnameExpanderFilter = new HostnameExpanderFilter(this);
        hostnameExpanderFilter.setPrefs(this.prefs);
        return hostnameExpanderFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    void process(String string) {
        this.messages.append(string);
    }
}

