/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.awt.Component;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.filter.CookieMonsterFilter;
import org.doit.muffin.filter.CookieMonsterFrame;

public class CookieMonster
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    CookieMonsterFrame frame;
    MessageArea messages;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putBoolean("CookieMonster.eatRequestCookies", true);
        prefs.putBoolean("CookieMonster.eatReplyCookies", true);
        prefs.putInteger("CookieMonster.historySize", 500);
        prefs.setOverride(bl);
        this.messages = new MessageArea(prefs.getInteger("CookieMonster.historySize"));
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new CookieMonsterFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        CookieMonsterFilter cookieMonsterFilter = new CookieMonsterFilter(this);
        cookieMonsterFilter.setPrefs(this.prefs);
        return cookieMonsterFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    void process(String string) {
        this.messages.append(string);
    }
}

