/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.doit.muffin.Prefs;
import org.doit.util.SortedProperties;

class UserPrefs
extends Prefs {
    String rcfile = "unknown";
    boolean loaded = false;

    UserPrefs() {
    }

    UserPrefs(String string) {
        this.setPrefsFile(string);
    }

    void setPrefsFile(String string) {
        this.rcfile = string;
    }

    void unload() {
        this.clear();
        this.loaded = false;
    }

    void load() {
        if (this.loaded) {
            return;
        }
        File file = new File(this.getUserFile(this.rcfile));
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.put(string, ((Hashtable)properties).get(string));
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.loaded = true;
    }

    void save() {
        Object object;
        SortedProperties sortedProperties = new SortedProperties();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            ((Hashtable)sortedProperties).put(object, this.get(object));
        }
        this.checkUserDirectory();
        object = new File(this.getUserFile(this.rcfile));
        System.out.println("Saving " + ((File)object).getAbsolutePath());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            sortedProperties.save(fileOutputStream, null);
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }
}

