/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.net.InetAddress;
import org.doit.muffin.About;
import org.doit.muffin.CanvasMonitor;
import org.doit.muffin.Configuration;
import org.doit.muffin.ConfigurationListener;
import org.doit.muffin.ConnectionsFrame;
import org.doit.muffin.FilterManager;
import org.doit.muffin.HelpFrame;
import org.doit.muffin.Icon;
import org.doit.muffin.Janitor;
import org.doit.muffin.Monitor;
import org.doit.muffin.MuffinFrame;
import org.doit.muffin.Options;
import org.doit.muffin.Prefs;
import org.doit.muffin.RegexFrame;
import org.doit.muffin.Server;
import org.doit.muffin.TextMonitor;
import org.doit.muffin.ThreadsFrame;

public class Main
extends MuffinFrame
implements ActionListener,
WindowListener,
ConfigurationListener {
    static final String version = "0.7.2";
    static Options options;
    static Configuration configs;
    static FilterManager manager;
    String localhost;
    Monitor monitor;
    Server server;
    String infoString = new String("Muffin " + options.getString("muffin.version") + " running on " + options.getString("muffin.host") + " port " + options.getString("muffin.port"));
    Label infoLabel;
    Button suspendButton;

    public Main() {
        super("Muffin");
        manager = new FilterManager(options, configs);
        if (options.getBoolean("muffin.noWindow")) {
            TextMonitor textMonitor = new TextMonitor(this.infoString);
            this.monitor = textMonitor;
        } else {
            this.monitor = new CanvasMonitor();
            this.gui();
        }
        new Thread(new Janitor()).start();
        this.server = new Server(options.getInteger("muffin.port"), this.monitor, manager, options);
        System.out.println(this.infoString);
        this.server.run();
    }

    void gui() {
        Serializable serializable;
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        MenuItem menuItem = new MenuItem("Quit");
        menuItem.setActionCommand("doQuit");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu("View");
        menuItem = new MenuItem("Configurations...");
        menuItem.setActionCommand("doConfigs");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Connections...");
        menuItem.setActionCommand("doConnections");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Filters...");
        menuItem.setActionCommand("doFilters");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Options...");
        menuItem.setActionCommand("doOptions");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Regex Tester...");
        menuItem.setActionCommand("doRegex");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Threads...");
        menuItem.setActionCommand("doThreads");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu("Help");
        menuItem = new MenuItem("About Muffin...");
        menuItem.setActionCommand("doAbout");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("License...");
        menuItem.setActionCommand("doLicense");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
        if (this.monitor instanceof Canvas) {
            serializable = (Canvas)((Object)this.monitor);
            this.add("Center", (Component)serializable);
        }
        serializable = new GridBagLayout();
        Panel panel = new Panel();
        panel.setLayout((LayoutManager)((Object)serializable));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 1.0;
        Button button = new Button("Filters...");
        button.setFont(new Font("Helvetica", 1, 12));
        button.setActionCommand("doFilters");
        button.addActionListener(this);
        ((GridBagLayout)serializable).setConstraints(button, gridBagConstraints);
        panel.add(button);
        button = new Button("Options...");
        button.setActionCommand("doOptions");
        button.addActionListener(this);
        ((GridBagLayout)serializable).setConstraints(button, gridBagConstraints);
        panel.add(button);
        this.suspendButton = new Button("Suspend");
        this.suspendButton.setActionCommand("doSuspend");
        this.suspendButton.addActionListener(this);
        ((GridBagLayout)serializable).setConstraints(this.suspendButton, gridBagConstraints);
        panel.add(this.suspendButton);
        button = new Button("Stop");
        button.setActionCommand("doStop");
        button.addActionListener(this);
        ((GridBagLayout)serializable).setConstraints(button, gridBagConstraints);
        panel.add(button);
        Icon icon = new Icon(options);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)serializable).setConstraints(icon, gridBagConstraints);
        panel.add(icon);
        this.add("North", panel);
        this.infoLabel = new Label(this.infoString);
        this.infoLabel.setFont(options.getFont("muffin.smallfont"));
        this.add("South", this.infoLabel);
        this.addWindowListener(this);
        configs.addConfigurationListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
        this.show();
    }

    public void configurationChanged(String string) {
        this.infoLabel.setText(String.valueOf(this.infoString) + " (" + string + ")");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doQuit".equals(string)) {
            this.closeApplication();
            return;
        }
        if ("doConnections".equals(string)) {
            new ConnectionsFrame(this.monitor);
            return;
        }
        if ("doThreads".equals(string)) {
            new ThreadsFrame(Thread.currentThread());
            return;
        }
        if ("doRegex".equals(string)) {
            new RegexFrame();
            return;
        }
        if ("doAbout".equals(string)) {
            new About(options);
            return;
        }
        if ("doLicense".equals(string)) {
            new HelpFrame("COPYING");
            return;
        }
        if ("doStop".equals(string)) {
            this.server.stop();
            return;
        }
        if ("doSuspend".equals(string)) {
            this.suspendButton.setLabel("Resume");
            this.suspendButton.setActionCommand("doResume");
            this.server.suspend();
            this.monitor.suspend();
            return;
        }
        if ("doResume".equals(string)) {
            this.suspendButton.setLabel("Suspend");
            this.suspendButton.setActionCommand("doSuspend");
            this.server.resume();
            this.monitor.resume();
            return;
        }
        if ("doFilters".equals(string)) {
            manager.createFrame();
            return;
        }
        if ("doOptions".equals(string)) {
            options.createFrame();
            return;
        }
        if ("doConfigs".equals(string)) {
            configs.createFrame();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.closeApplication();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    void closeApplication() {
        manager.disableAll();
        ((Component)this).setVisible(false);
        System.exit(0);
    }

    static void systemInfo() {
        System.out.println("Muffin:");
        System.out.println("-------");
        System.out.println("muffin.version 0.7.2");
        System.out.println();
        System.out.println("Java Virtual Machine:");
        System.out.println("---------------------");
        System.out.println("java.version " + System.getProperty("java.version"));
        System.out.println("java.class.version " + System.getProperty("java.class.version"));
        System.out.println("java.class.path " + System.getProperty("java.class.path"));
        System.out.println("java.home " + System.getProperty("java.home"));
        System.out.println("java.vendor " + System.getProperty("java.vendor"));
        System.out.println();
        System.out.println("Operating System:");
        System.out.println("-----------------");
        System.out.println("os.version " + System.getProperty("os.version"));
        System.out.println("os.arch " + System.getProperty("os.arch"));
        System.out.println("os.name " + System.getProperty("os.name"));
        System.out.println();
        System.out.println("User:");
        System.out.println("-----");
        System.out.println("user.name " + System.getProperty("user.name"));
        System.out.println("user.dir " + System.getProperty("user.dir"));
        System.out.println("user.home " + System.getProperty("user.home"));
    }

    static String copyleft() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Muffin version 0.7.2, Copyright (C) 1996-1998 Mark R. Boyns <boyns@doit.org>\n");
        stringBuffer.append("Muffin comes with ABSOLUTELY NO WARRANTY; for details see Help/License.\n");
        stringBuffer.append("This is free software, and you are welcome to redistribute it\n");
        stringBuffer.append("under certain conditions; see Help/License for details.\n");
        return stringBuffer.toString();
    }

    public static Options getOptions() {
        return options;
    }

    public static FilterManager getFilterManager() {
        return manager;
    }

    public static void main(String[] stringArray) {
        int n;
        System.out.println(Main.copyleft());
        LongOpt[] longOptArray = new LongOpt[]{new LongOpt("port", 1, null, 112), new LongOpt("conf", 1, null, 99), new LongOpt("dir", 1, null, 100), new LongOpt("httpProxyHost", 1, null, 2), new LongOpt("httpProxyPort", 1, null, 3), new LongOpt("httpsProxyHost", 1, null, 4), new LongOpt("httpsProxyPort", 1, null, 5), new LongOpt("nw", 0, null, 6), new LongOpt("font", 1, null, 7), new LongOpt("smallfont", 1, null, 8), new LongOpt("bigfont", 1, null, 9), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118)};
        Prefs prefs = new Prefs();
        Getopt getopt = new Getopt("Muffin", stringArray, "v", longOptArray, true);
        block24: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 112: {
                    try {
                        prefs.putInteger("port", Integer.parseInt(getopt.getOptarg()));
                    }
                    catch (Exception exception) {
                        System.out.println("invalid port: " + getopt.getOptarg());
                        System.exit(1);
                    }
                    continue block24;
                }
                case 99: {
                    prefs.putString("conf", getopt.getOptarg());
                    break;
                }
                case 100: {
                    prefs.putString("dir", getopt.getOptarg());
                    break;
                }
                case 2: {
                    prefs.putString("httpProxyHost", getopt.getOptarg());
                    break;
                }
                case 3: {
                    try {
                        prefs.putInteger("httpProxyPort", Integer.parseInt(getopt.getOptarg()));
                    }
                    catch (Exception exception) {
                        System.out.println("invalid httpProxyPort: " + getopt.getOptarg());
                        System.exit(1);
                    }
                    continue block24;
                }
                case 4: {
                    prefs.putString("httpsProxyHost", getopt.getOptarg());
                    break;
                }
                case 5: {
                    try {
                        prefs.putInteger("httpsProxyPort", Integer.parseInt(getopt.getOptarg()));
                    }
                    catch (Exception exception) {
                        System.out.println("invalid httpsProxyPort: " + getopt.getOptarg());
                        System.exit(1);
                    }
                    continue block24;
                }
                case 6: {
                    prefs.putBoolean("noWindow", true);
                    break;
                }
                case 118: {
                    Main.systemInfo();
                    System.exit(0);
                    break;
                }
                case 7: {
                    prefs.putString("font", getopt.getOptarg());
                    break;
                }
                case 8: {
                    prefs.putString("smallfont", getopt.getOptarg());
                    break;
                }
                case 9: {
                    prefs.putString("bigfont", getopt.getOptarg());
                    break;
                }
                case 104: {
                    System.out.println("usage: java Muffin [options]\n\n-conf NAME            Default configuration.\n-dir DIR              Preferences directory.\n-font FONT            Default font.\n-smallfont FONT       Font used for small text.\n-bigfont FONT         Font used for large text.\n-help                 This useful message.\n-httpProxyHost HOST   Use HOST as the HTTP proxy.\n-httpProxyPort PORT   Use PORT as the HTTP proxy port.\n-httpsProxyHost HOST  Use HOST as the SSL proxy.\n-httpsProxyPort PORT  Use PORT as the SSL proxy port.\n-nw                   Don't create any windows.\n-port PORT            Listen on PORT for browser requests.\n-v                    Display muffin version.\n");
                    System.exit(0);
                    break;
                }
                case 63: {
                    System.exit(1);
                }
            }
        }
        configs = new Configuration();
        if (prefs.exists("dir")) {
            configs.setUserDirectory(prefs.getString("dir"));
        }
        configs.load();
        configs.scan();
        String string = "default.conf";
        if (prefs.exists("conf")) {
            string = prefs.getString("conf");
        }
        configs.setDefault(string);
        configs.setCurrent(string);
        options = new Options(configs);
        options.putString("muffin.version", version);
        options.putString("muffin.url", "http://muffin.doit.org/");
        try {
            options.putString("muffin.host", InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            options.putString("muffin.host", "127.0.0.1");
        }
        if (prefs.exists("port")) {
            options.putInteger("muffin.port", prefs.getInteger("port"));
        }
        if (prefs.exists("httpProxyHost")) {
            options.putString("muffin.httpProxyHost", prefs.getString("httpProxyHost"));
        }
        if (prefs.exists("httpProxyPort")) {
            options.putInteger("muffin.httpProxyPort", prefs.getInteger("httpProxyPort"));
        }
        if (prefs.exists("httpsProxyHost")) {
            options.putString("muffin.httpsProxyHost", prefs.getString("httpsProxyHost"));
        }
        if (prefs.exists("httpsProxyPort")) {
            options.putInteger("muffin.httpsProxyPort", prefs.getInteger("httpsProxyPort"));
        }
        if (prefs.exists("noWindow")) {
            options.putBoolean("muffin.noWindow", prefs.getBoolean("noWindow"));
        }
        if (prefs.exists("font")) {
            options.putString("muffin.font", prefs.getString("font"));
        }
        if (prefs.exists("smallfont")) {
            options.putString("muffin.smallfont", prefs.getString("smallfont"));
        }
        if (prefs.exists("bigfont")) {
            options.putString("muffin.bigfont", prefs.getString("bigfont"));
        }
        options.sync();
        new Main();
    }
}

