/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import org.doit.muffin.Httpd;
import org.doit.muffin.Options;
import org.doit.muffin.Reply;

class HttpError {
    StringBuffer content;
    Reply reply;

    HttpError(Options options, int n, String string) {
        String string2;
        switch (n) {
            case 400: {
                string2 = "Bad Request";
                break;
            }
            case 403: {
                string2 = "Forbidden";
                break;
            }
            case 404: {
                string2 = "Not found";
                break;
            }
            case 503: {
                string2 = "Service Unavailable";
                break;
            }
            default: {
                string2 = "Error";
            }
        }
        this.reply = new Reply();
        this.reply.statusLine = "HTTP/1.0 " + n + " " + string2;
        this.reply.setHeaderField("Content-type", "text/html");
        this.reply.setHeaderField("Server", "Muffin/" + options.getString("muffin.version"));
        this.content = new StringBuffer();
        this.content.append(Httpd.head(string2));
        this.content.append(string);
        this.content.append(Httpd.tail());
    }

    Reply getReply() {
        return this.reply;
    }

    String getContent() {
        if (this.content == null) {
            return null;
        }
        return this.content.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.reply != null) {
            stringBuffer.append(this.reply.toString());
        }
        if (this.content != null) {
            stringBuffer.append(this.content.toString());
        }
        return stringBuffer.toString();
    }
}

