/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

class Connection {
    Socket socket;
    InputStream in;
    OutputStream out;

    Connection(Socket socket) throws IOException {
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
    }

    Connection(String string, int n) throws IOException {
        this(new Socket(string, n));
    }

    Connection() {
    }

    InputStream getInputStream() {
        return this.in;
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
                return;
            }
            catch (Exception exception) {
                System.out.println("Connection: " + exception);
                return;
            }
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public String toString() {
        return String.valueOf(this.getInetAddress()) + ":" + this.getPort();
    }
}

