/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.REMatch;
import gnu.regexp.REToken;
import java.io.Serializable;

class RETokenPOSIX
extends REToken
implements Serializable {
    int m_type;
    boolean m_insens;
    boolean m_negated;
    static final int ALNUM = 0;
    static final int ALPHA = 1;
    static final int BLANK = 2;
    static final int CNTRL = 3;
    static final int DIGIT = 4;
    static final int GRAPH = 5;
    static final int LOWER = 6;
    static final int PRINT = 7;
    static final int PUNCT = 8;
    static final int SPACE = 9;
    static final int UPPER = 10;
    static final int XDIGIT = 11;

    RETokenPOSIX(int n, boolean bl, boolean bl2) {
        this.m_type = n;
        this.m_insens = bl;
        this.m_negated = bl2;
    }

    int match(String string, int n, int n2, REMatch rEMatch) {
        if (n >= string.length()) {
            return -1;
        }
        char c = string.charAt(n);
        boolean bl = false;
        switch (this.m_type) {
            case 0: {
                bl = Character.isLetterOrDigit(c);
                break;
            }
            case 1: {
                bl = Character.isLetter(c);
                break;
            }
            case 2: {
                bl = c == ' ' || c == '\t';
                break;
            }
            case 3: {
                bl = Character.isISOControl(c);
                break;
            }
            case 4: {
                bl = Character.isDigit(c);
                break;
            }
            case 5: {
                bl = !Character.isWhitespace(c) && !Character.isISOControl(c);
                break;
            }
            case 6: {
                bl = this.m_insens && Character.isLetter(c) || Character.isLowerCase(c);
                break;
            }
            case 7: {
                bl = Character.isLetterOrDigit(c);
                break;
            }
            case 8: {
                bl = "`~!@#$%^&*()-_=+[]{}\\|;:'\"/?,.<>".indexOf(c) != -1;
                break;
            }
            case 9: {
                bl = Character.isWhitespace(c);
                break;
            }
            case 10: {
                bl = this.m_insens && Character.isLetter(c) || Character.isUpperCase(c);
                break;
            }
            case 11: {
                boolean bl2 = bl = Character.isDigit(c) || "abcdefABCDEF".indexOf(c) != -1;
            }
        }
        if (this.m_negated) {
            boolean bl3 = bl = !bl;
        }
        if (bl) {
            return this.next(string, n + 1, n2, rEMatch);
        }
        return -1;
    }
}

