/*
 * Decompiled with CFR 0.152.
 */
package muffin.io;

import java.io.IOException;
import java.io.InputStream;
import muffin.io.ByteArray;
import muffin.io.InputObjectStream;

public class ObjectStreamToInputStream
extends InputStream {
    protected InputObjectStream in;
    protected ByteArray array;
    protected int index;

    public ObjectStreamToInputStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public int read() throws IOException {
        if (this.array == null) {
            Object object = this.in.read();
            if (object == null) {
                return -1;
            }
            if (object instanceof ByteArray) {
                this.array = (ByteArray)object;
            } else if (object instanceof String) {
                this.array = new ByteArray((String)object);
            } else {
                throw new IOException("Unknown Object " + object.toString());
            }
            this.index = 0;
        }
        byte by = this.array.bytes[this.index++];
        if (this.index == this.array.length()) {
            this.array = null;
            this.index = 0;
        }
        return by & 0xFF;
    }
}

