/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import JP.ac.osaka_u.ender.util.regex.MatchInfo;
import JP.ac.osaka_u.ender.util.regex.NFABuildException;
import JP.ac.osaka_u.ender.util.regex.RegExp;
import JP.ac.osaka_u.ender.util.regex.RegExpSyntaxException;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import muffin.Filter;
import muffin.FilterFactory;
import muffin.FilterManager;
import muffin.MessageArea;
import muffin.Prefs;
import muffin.filter.NoThanksFilter;
import muffin.filter.NoThanksFrame;
import muffin.html.Tag;

public class NoThanks
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    NoThanksFrame frame;
    MessageArea messages;
    String[] hyperlist = new String[]{"href", "src", "action", "base", "background"};
    private RegExp kill;
    private RegExp comment;
    private RegExp hypertags;
    private RegExp content;
    private Hashtable strip;
    private Vector redirectPatterns;
    private Vector redirectLocations;
    private Hashtable replace;
    private Hashtable tagattrTags;
    private Hashtable tagattrStrip;
    private Hashtable tagattrRemove;
    private Hashtable tagattrReplace;
    private Hashtable tagattrReplaceValue;
    private StringBuffer killBuffer;
    private StringBuffer commentBuffer;
    private StringBuffer contentBuffer;

    public NoThanks() {
        try {
            this.hypertags = new RegExp("^a|img|background|form|iframe|layer$");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        String string = prefs.getUserFile("killfile");
        prefs.putString("NoThanks.killfile", string);
        prefs.putInteger("NoThanks.historySize", 500);
        prefs.setOverride(bl);
        this.messages = new MessageArea(prefs.getInteger("NoThanks.historySize"));
        this.load();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new NoThanksFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        NoThanksFilter noThanksFilter = new NoThanksFilter(this);
        noThanksFilter.setPrefs(this.prefs);
        return noThanksFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    boolean isKilled(String string) {
        if (this.kill == null) {
            return false;
        }
        MatchInfo matchInfo = this.kill.match(string);
        return matchInfo != null;
    }

    boolean killComment(String string) {
        if (this.comment == null) {
            return false;
        }
        MatchInfo matchInfo = this.comment.match(string);
        return matchInfo != null;
    }

    boolean killContent(String string) {
        if (this.content == null) {
            return false;
        }
        MatchInfo matchInfo = this.content.match(string);
        return matchInfo != null;
    }

    boolean stripTag(String string) {
        return this.strip.containsKey(string);
    }

    String stripUntil(String string) {
        String string2 = (String)this.strip.get(string);
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    boolean replaceTag(String string) {
        return this.replace.containsKey(string);
    }

    Tag replaceTagWith(String string) {
        return (Tag)this.replace.get(string);
    }

    String redirect(String string) {
        int n = 0;
        while (n < this.redirectPatterns.size()) {
            RegExp regExp = (RegExp)this.redirectPatterns.elementAt(n);
            MatchInfo matchInfo = regExp.match(string);
            if (matchInfo != null) {
                return (String)this.redirectLocations.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    boolean checkTag(String string) {
        MatchInfo matchInfo = this.hypertags.match(string);
        return matchInfo != null;
    }

    boolean compare(String string, RegExp regExp) {
        if (string.length() == 0 && regExp.toString().equals(".*")) {
            return true;
        }
        MatchInfo matchInfo = regExp.match(string);
        return matchInfo != null;
    }

    boolean checkTagAttributes(Tag tag) {
        return this.tagattrTags.containsKey(tag.name());
    }

    /*
     * Unable to fully structure code
     */
    boolean processTagAttributes(Tag var1_1) {
        var2_2 = var1_1.enumerate();
        if (var2_2 != null) ** GOTO lbl19
        return false;
lbl-1000:
        // 1 sources

        {
            var3_3 = (String)var2_2.nextElement();
            var4_4 = String.valueOf(var1_1.name()) + "." + var3_3;
            if (this.tagattrStrip.containsKey(var4_4)) {
                if (!this.compare(var1_1.get(var3_3), (RegExp)this.tagattrStrip.get(var4_4))) continue;
                this.process("tagattr stripped " + var1_1.toString() + "\n");
                return true;
            }
            if (this.tagattrRemove.containsKey(var4_4)) {
                if (!this.compare(var1_1.get(var3_3), (RegExp)this.tagattrRemove.get(var4_4))) continue;
                this.process("tagattr removed " + var3_3 + " from " + var1_1.name() + "\n");
                var1_1.remove(var3_3);
                continue;
            }
            if (!this.tagattrReplace.containsKey(var4_4) || !this.compare(var1_1.get(var3_3), (RegExp)this.tagattrReplace.get(var4_4))) continue;
            this.process("tagattr replaced " + var3_3 + " in " + var1_1.name() + "\n");
            var1_1.put(var3_3, (String)this.tagattrReplaceValue.get(var4_4));
lbl19:
            // 6 sources

            ** while (var2_2.hasMoreElements())
        }
lbl20:
        // 1 sources

        return false;
    }

    void save() {
        this.manager.save(this);
    }

    void load() {
        String string = this.prefs.getUserFile(this.prefs.getString("NoThanks.killfile"));
        try {
            this.load(new FileReader(new File(string)));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void load(Reader reader) {
        this.strip = new Hashtable(33);
        this.redirectPatterns = new Vector();
        this.redirectLocations = new Vector();
        this.replace = new Hashtable(33);
        this.tagattrTags = new Hashtable(33);
        this.tagattrStrip = new Hashtable(33);
        this.tagattrRemove = new Hashtable(33);
        this.tagattrReplace = new Hashtable(33);
        this.tagattrReplaceValue = new Hashtable(33);
        this.killBuffer = new StringBuffer();
        this.commentBuffer = new StringBuffer();
        this.contentBuffer = new StringBuffer();
        this.include(reader);
        try {
            this.kill = this.killBuffer.length() > 0 ? new RegExp(this.killBuffer.toString()) : null;
            this.comment = this.commentBuffer.length() > 0 ? new RegExp(this.commentBuffer.toString()) : null;
            this.content = this.contentBuffer.length() > 0 ? new RegExp(this.contentBuffer.toString()) : null;
            return;
        }
        catch (RegExpSyntaxException regExpSyntaxException) {
            System.out.println("NoThanks RegExpSyntaxException: " + regExpSyntaxException.getMessage());
            return;
        }
        catch (NFABuildException nFABuildException) {
            System.out.println("NoThanks NFABuildException: " + nFABuildException.getMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void include(Reader reader) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((string = bufferedReader.readLine()) != null) {
                Vector vector;
                String string2;
                Object object;
                String string3;
                StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
                streamTokenizer.resetSyntax();
                streamTokenizer.whitespaceChars(0, 32);
                streamTokenizer.wordChars(33, 126);
                streamTokenizer.quoteChar(34);
                streamTokenizer.eolIsSignificant(true);
                int n = streamTokenizer.nextToken();
                if (n != -3) continue;
                if (streamTokenizer.sval.startsWith("#")) {
                    if (!streamTokenizer.sval.equals("#include")) continue;
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    String string4 = this.prefs.getUserFile(streamTokenizer.sval);
                    this.include(new FileReader(new File(string4)));
                    continue;
                }
                if (streamTokenizer.sval.equals("kill")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    if (this.killBuffer.length() > 0) {
                        this.killBuffer.append("|");
                    }
                    this.killBuffer.append(streamTokenizer.sval);
                    continue;
                }
                if (streamTokenizer.sval.equals("comment")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    if (this.commentBuffer.length() > 0) {
                        this.commentBuffer.append("|");
                    }
                    this.commentBuffer.append(streamTokenizer.sval);
                    continue;
                }
                if (streamTokenizer.sval.equals("strip")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    String string5 = new String(streamTokenizer.sval);
                    string3 = "";
                    n = streamTokenizer.nextToken();
                    if (n == -3 || n == 34) {
                        string3 = new String(streamTokenizer.sval);
                    }
                    this.strip.put(string5.toLowerCase(), string3.toLowerCase());
                    continue;
                }
                if (streamTokenizer.sval.equals("content")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    if (this.contentBuffer.length() > 0) {
                        this.contentBuffer.append("|");
                    }
                    this.contentBuffer.append(streamTokenizer.sval);
                    continue;
                }
                if (streamTokenizer.sval.equals("redirect")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    String string6 = new String(streamTokenizer.sval);
                    string3 = "";
                    n = streamTokenizer.nextToken();
                    if (n == -3 || n == 34) {
                        string3 = new String(streamTokenizer.sval);
                    }
                    try {
                        object = new RegExp(string6);
                        this.redirectPatterns.addElement(object);
                        this.redirectLocations.addElement(string3);
                    }
                    catch (RegExpSyntaxException regExpSyntaxException) {
                        System.out.println(String.valueOf(string6) + " " + regExpSyntaxException.getMessage());
                    }
                    catch (NFABuildException nFABuildException) {
                        System.out.println(String.valueOf(string6) + " " + nFABuildException.getMessage());
                    }
                    continue;
                }
                if (streamTokenizer.sval.equals("replace")) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    String string7 = new String(streamTokenizer.sval);
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    string3 = new String(streamTokenizer.sval);
                    object = null;
                    string2 = null;
                    int n2 = string3.indexOf(" \t");
                    if (n2 == -1) {
                        object = string3;
                    } else {
                        object = string3.substring(n2);
                        string2 = string3.substring(n2 + 1);
                    }
                    vector = new Tag((String)object, string2);
                    this.replace.put(string7.toLowerCase(), vector);
                    continue;
                }
                if (streamTokenizer.sval.equals("tagattr")) {
                    int n3;
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34 || (n3 = streamTokenizer.sval.indexOf(46)) == -1) break;
                    string3 = streamTokenizer.sval.substring(0, n3);
                    string3 = string3.toLowerCase();
                    object = streamTokenizer.sval.substring(n3 + 1);
                    object = ((String)object).toLowerCase();
                    string2 = String.valueOf(string3) + "." + (String)object;
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34) break;
                    String string8 = new String(streamTokenizer.sval);
                    vector = (Vector)this.tagattrTags.get(string3);
                    if (vector == null) {
                        vector = new Vector();
                        this.tagattrTags.put(string3, vector);
                    }
                    vector.addElement(object);
                    n = streamTokenizer.nextToken();
                    String string9 = n != -3 && n != 34 ? ".*" : new String(streamTokenizer.sval);
                    RegExp regExp = new RegExp(string9);
                    if (string8.equals("strip")) {
                        this.tagattrStrip.put(string2, regExp);
                        continue;
                    }
                    if (string8.equals("remove")) {
                        this.tagattrRemove.put(string2, regExp);
                        continue;
                    }
                    if (string8.equals("replace")) {
                        n = streamTokenizer.nextToken();
                        if (n != -3 && n != 34) {
                            System.out.println("tagattr replace missing value");
                            break;
                        }
                        String string10 = new String(streamTokenizer.sval);
                        this.tagattrReplace.put(string2, regExp);
                        this.tagattrReplaceValue.put(string2, string10);
                        continue;
                    }
                    System.out.println("tagattr " + string8 + " unknown command");
                    continue;
                }
                System.out.println("NoThanks: " + streamTokenizer.sval + " unknown command");
            }
            bufferedReader.close();
            return;
        }
        catch (RegExpSyntaxException regExpSyntaxException) {
            System.out.println("NoThanks RegExpSyntaxException: " + regExpSyntaxException.getMessage());
            return;
        }
        catch (NFABuildException nFABuildException) {
            System.out.println("NoThanks NFABuildException: " + nFABuildException.getMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void process(String string) {
        this.messages.append(string);
    }
}

