/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import muffin.Prefs;
import muffin.RedirectFilter;
import muffin.Request;
import muffin.filter.HostnameExpander;

public class HostnameExpanderFilter
implements RedirectFilter {
    static final String[] expandDomains = new String[]{".com", ".edu", ".net", ".org"};
    Prefs prefs;
    HostnameExpander factory;

    HostnameExpanderFilter(HostnameExpander hostnameExpander) {
        this.factory = hostnameExpander;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsRedirection(Request request) {
        String string = request.getHost();
        return string.indexOf(".") < 0;
    }

    public String redirect(Request request) {
        String string = this.expandHostname(request.getHost());
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("http://");
            stringBuffer.append(string);
            if (request.getPort() != 80) {
                stringBuffer.append(":");
                stringBuffer.append(request.getPort());
            }
            stringBuffer.append(request.getPath());
            this.factory.process(String.valueOf(request.getHost()) + " -> " + stringBuffer.toString() + "\n");
            return stringBuffer.toString();
        }
        return null;
    }

    String expandHostname(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        if (inetAddress == null) {
            int n = 0;
            while (n < expandDomains.length) {
                String string2 = "www." + string + expandDomains[n];
                try {
                    inetAddress = InetAddress.getByName(string2);
                }
                catch (UnknownHostException unknownHostException) {
                    inetAddress = null;
                }
                if (inetAddress != null) {
                    return string2;
                }
                ++n;
            }
        }
        return null;
    }
}

