/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import muffin.ContentFilter;
import muffin.Filter;
import muffin.FilterFactory;
import muffin.FilterManager;
import muffin.Prefs;
import muffin.Reply;
import muffin.Request;
import muffin.filter.Test;
import muffin.html.Tag;
import muffin.html.Token;
import muffin.io.ByteArray;
import muffin.io.InputObjectStream;
import muffin.io.OutputObjectStream;

public class DocumentInfo
implements FilterFactory,
ContentFilter {
    FilterManager manager;
    Prefs prefs;
    Test factory;
    InputObjectStream in;
    OutputObjectStream out;
    Reply reply;
    Request request;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        System.out.println("DocumentInfo: no preferences");
    }

    public Filter createFilter() {
        DocumentInfo documentInfo = new DocumentInfo();
        documentInfo.setPrefs(this.prefs);
        return documentInfo;
    }

    public void shutdown() {
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        this.reply = reply;
        String string = reply.getContentType();
        return string != null && string.startsWith("text/html");
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    public void run() {
        Thread.currentThread().setName("DocumentInfo");
        try {
            Object object;
            while ((object = this.in.read()) != null) {
                Object object2;
                Tag tag;
                this.out.write(object);
                Token token = (Token)object;
                if (token.getType() != -2 || !(tag = token.createTag()).is("body")) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<small>\n");
                stringBuffer.append("URL: ");
                stringBuffer.append(this.request.getURL());
                stringBuffer.append("<br>\n");
                if (this.reply.containsHeaderField("Server")) {
                    stringBuffer.append("Server: ");
                    stringBuffer.append(this.reply.getHeaderField("Server"));
                    stringBuffer.append("<br>\n");
                }
                if (this.reply.containsHeaderField("Last-Modified")) {
                    stringBuffer.append("Last-Modified: ");
                    object2 = this.reply.getHeaderField("Last-Modified");
                    try {
                        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance();
                        switch (((String)object2).charAt(3)) {
                            case ',': {
                                simpleDateFormat.applyPattern("EEE, dd MMM yyyy HH:mm:ss z");
                                break;
                            }
                            case ' ': {
                                simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss yyyy");
                                break;
                            }
                            default: {
                                simpleDateFormat.applyPattern("EEEE, dd-MMM-yyyy HH:mm:ss z");
                            }
                        }
                        ParsePosition parsePosition = new ParsePosition(0);
                        Date date = simpleDateFormat.parse(this.reply.getHeaderField("Last-Modified"), parsePosition);
                        stringBuffer.append(simpleDateFormat.format(date));
                    }
                    catch (Exception exception) {
                        stringBuffer.append((String)object2);
                    }
                    stringBuffer.append("<br>\n");
                }
                stringBuffer.append("</small>\n");
                object2 = new Token();
                ((ByteArray)object2).append(stringBuffer.toString());
                this.out.write(object2);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

