/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import muffin.Message;

public class Reply
extends Message {
    void read(InputStream inputStream) throws IOException {
        this.statusLine = this.readLine(inputStream);
        this.readHeaders(inputStream);
        int n = this.getStatusCode();
        switch (n) {
            case 204: 
            case 304: {
                int n2;
                if (!this.containsHeaderField("Content-length")) break;
                System.out.println("RFC 2068: Ignoring message-body from " + n + " response - " + this.getHeaderField("Server"));
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(this.getHeaderField("Content-length"));
                }
                catch (Exception exception) {}
                byte[] byArray = new byte[8192];
                while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                }
                this.removeHeaderField("Content-length");
                return;
            }
        }
    }

    void write(OutputStream outputStream) throws IOException {
        String string = this.toString();
        outputStream.write(string.getBytes(), 0, string.length());
        outputStream.flush();
    }

    boolean hasContent() {
        switch (this.getStatusCode()) {
            case 204: 
            case 304: {
                return false;
            }
        }
        return true;
    }

    public String getProtocol() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.statusLine);
        String string = stringTokenizer.nextToken();
        return string;
    }

    public int getStatusCode() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.statusLine);
        stringTokenizer.nextToken();
        String string = stringTokenizer.nextToken();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            System.out.println("Malformed or missing status code");
        }
        return n;
    }

    private Hashtable contentTypeParser() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = this.getHeaderField("Content-type");
        if (string == null) {
            return hashtable;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n2 = (string4 = string4.trim()).indexOf(61);
            if (n2 != -1) {
                string3 = string4.substring(0, n2);
                string2 = string4.substring(n2 + 1);
            } else {
                string3 = string4;
                string2 = "";
            }
            if (n == 0) {
                hashtable.put("Content-type", string3);
            } else {
                hashtable.put(string3, string2);
            }
            ++n;
        }
        return hashtable;
    }

    public String getContentType() {
        Hashtable hashtable = this.contentTypeParser();
        return (String)hashtable.get("Content-type");
    }

    public String getBoundary() {
        Hashtable hashtable = this.contentTypeParser();
        return (String)hashtable.get("boundary");
    }

    public static Reply createRedirect(String string) {
        Reply reply = new Reply();
        reply.setStatusLine("HTTP/1.0 302 Moved Temporarily");
        reply.setHeaderField("Location", string);
        return reply;
    }
}

