/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.net.InetAddress;
import muffin.About;
import muffin.CanvasMonitor;
import muffin.Configuration;
import muffin.ConfigurationListener;
import muffin.ConnectionsFrame;
import muffin.FilterManager;
import muffin.Icon;
import muffin.Monitor;
import muffin.Options;
import muffin.Prefs;
import muffin.RegexFrame;
import muffin.Server;
import muffin.TextMonitor;
import muffin.ThreadsFrame;

public class Main
extends Frame
implements ActionListener,
WindowListener,
ConfigurationListener {
    static final String version = "0.6";
    static Options options;
    static Configuration configs;
    String localhost;
    Monitor monitor;
    Server server;
    FilterManager manager;
    String infoString = new String("Muffin " + options.getString("muffin.version") + " running on " + options.getString("muffin.host") + " port " + options.getString("muffin.port"));
    Label infoLabel;
    Button suspendButton;

    public Main() {
        super("Muffin");
        System.out.println(this.infoString);
        this.manager = new FilterManager(options, configs);
        if (options.getBoolean("muffin.noWindow")) {
            TextMonitor textMonitor = new TextMonitor(this.infoString);
            this.monitor = textMonitor;
        } else {
            this.monitor = new CanvasMonitor();
            this.gui();
        }
        this.server = new Server(options.getInteger("muffin.port"), this.monitor, this.manager, options);
        this.server.run();
    }

    void gui() {
        Serializable serializable;
        ((Component)this).setBackground(Color.lightGray);
        ((Component)this).setFont(new Font("Helvetica", 1, 12));
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menu.setFont(new Font("Helvetica", 1, 12));
        MenuItem menuItem = new MenuItem("Quit");
        menuItem.setActionCommand("doQuit");
        menuItem.addActionListener(this);
        menuItem.setFont(new Font("Helvetica", 1, 12));
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu("View");
        menu.setFont(new Font("Helvetica", 1, 12));
        menuItem = new MenuItem("Configurations...");
        menuItem.setActionCommand("doConfigs");
        menuItem.addActionListener(this);
        menuItem.setFont(new Font("Helvetica", 1, 12));
        menu.add(menuItem);
        menuItem = new MenuItem("Connections...");
        menuItem.setActionCommand("doConnections");
        menuItem.addActionListener(this);
        menuItem.setFont(new Font("Helvetica", 1, 12));
        menu.add(menuItem);
        menuItem = new MenuItem("Filters...");
        menuItem.setActionCommand("doFilters");
        menuItem.addActionListener(this);
        menuItem.setFont(new Font("Helvetica", 1, 12));
        menu.add(menuItem);
        menuItem = new MenuItem("Options...");
        menuItem.setActionCommand("doOptions");
        menuItem.addActionListener(this);
        menuItem.setFont(new Font("Helvetica", 1, 12));
        menu.add(menuItem);
        menuItem = new MenuItem("Regex Tester...");
        menuItem.setActionCommand("doRegex");
        menuItem.addActionListener(this);
        menuItem.setFont(new Font("Helvetica", 1, 12));
        menu.add(menuItem);
        menuItem = new MenuItem("Threads...");
        menuItem.setActionCommand("doThreads");
        menuItem.addActionListener(this);
        menuItem.setFont(new Font("Helvetica", 1, 12));
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu("Help");
        menu.setFont(new Font("Helvetica", 1, 12));
        menuItem = new MenuItem("About Muffin...");
        menuItem.setActionCommand("doAbout");
        menuItem.addActionListener(this);
        menuItem.setFont(new Font("Helvetica", 1, 12));
        menu.add(menuItem);
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
        if (this.monitor instanceof Canvas) {
            serializable = (Canvas)((Object)this.monitor);
            this.add("Center", (Component)serializable);
        }
        serializable = new GridBagLayout();
        Panel panel = new Panel();
        panel.setLayout((LayoutManager)((Object)serializable));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 1.0;
        Button button = new Button("Filters...");
        button.setActionCommand("doFilters");
        button.addActionListener(this);
        ((GridBagLayout)serializable).setConstraints(button, gridBagConstraints);
        panel.add(button);
        button = new Button("Options...");
        button.setActionCommand("doOptions");
        button.addActionListener(this);
        ((GridBagLayout)serializable).setConstraints(button, gridBagConstraints);
        panel.add(button);
        this.suspendButton = new Button("Suspend");
        this.suspendButton.setActionCommand("doSuspend");
        this.suspendButton.addActionListener(this);
        ((GridBagLayout)serializable).setConstraints(this.suspendButton, gridBagConstraints);
        panel.add(this.suspendButton);
        button = new Button("Stop");
        button.setActionCommand("doStop");
        button.addActionListener(this);
        ((GridBagLayout)serializable).setConstraints(button, gridBagConstraints);
        panel.add(button);
        Icon icon = new Icon(options);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)serializable).setConstraints(icon, gridBagConstraints);
        panel.add(icon);
        this.add("North", panel);
        this.infoLabel = new Label(this.infoString);
        this.infoLabel.setFont(new Font("Helvetica", 0, 10));
        this.add("South", this.infoLabel);
        this.addWindowListener(this);
        configs.addConfigurationListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
        this.show();
    }

    public void configurationChanged(String string) {
        this.infoLabel.setText(String.valueOf(this.infoString) + " (" + string + ")");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doQuit".equals(string)) {
            this.closeApplication();
            return;
        }
        if ("doConnections".equals(string)) {
            new ConnectionsFrame(this.monitor);
            return;
        }
        if ("doThreads".equals(string)) {
            new ThreadsFrame(Thread.currentThread());
            return;
        }
        if ("doRegex".equals(string)) {
            new RegexFrame();
            return;
        }
        if ("doAbout".equals(string)) {
            new About(options);
            return;
        }
        if ("doStop".equals(string)) {
            this.server.stop();
            return;
        }
        if ("doSuspend".equals(string)) {
            this.suspendButton.setLabel("Resume");
            this.suspendButton.setActionCommand("doResume");
            this.server.suspend();
            this.monitor.suspend();
            return;
        }
        if ("doResume".equals(string)) {
            this.suspendButton.setLabel("Suspend");
            this.suspendButton.setActionCommand("doSuspend");
            this.server.resume();
            this.monitor.resume();
            return;
        }
        if ("doFilters".equals(string)) {
            this.manager.createFrame();
            return;
        }
        if ("doOptions".equals(string)) {
            options.createFrame();
            return;
        }
        if ("doConfigs".equals(string)) {
            configs.createFrame();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.closeApplication();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    void closeApplication() {
        this.manager.disableAll();
        ((Component)this).setVisible(false);
        System.exit(0);
    }

    static void systemInfo() {
        System.out.println("Muffin:");
        System.out.println("-------");
        System.out.println("muffin.version 0.6");
        System.out.println();
        System.out.println("Java Virtual Machine:");
        System.out.println("---------------------");
        System.out.println("java.version " + System.getProperty("java.version"));
        System.out.println("java.class.version " + System.getProperty("java.class.version"));
        System.out.println("java.class.path " + System.getProperty("java.class.path"));
        System.out.println("java.home " + System.getProperty("java.home"));
        System.out.println("java.vendor " + System.getProperty("java.vendor"));
        System.out.println();
        System.out.println("Operating System:");
        System.out.println("-----------------");
        System.out.println("os.version " + System.getProperty("os.version"));
        System.out.println("os.arch " + System.getProperty("os.arch"));
        System.out.println("os.name " + System.getProperty("os.name"));
        System.out.println();
        System.out.println("User:");
        System.out.println("-----");
        System.out.println("user.name " + System.getProperty("user.name"));
        System.out.println("user.dir " + System.getProperty("user.dir"));
        System.out.println("user.home " + System.getProperty("user.home"));
    }

    public static void main(String[] stringArray) {
        Prefs prefs = new Prefs();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-port")) {
                try {
                    prefs.putInteger("port", Integer.parseInt(stringArray[++n]));
                }
                catch (Exception exception) {
                    System.out.println("invalid port: " + stringArray[n]);
                    System.exit(1);
                }
            } else if (stringArray[n].equalsIgnoreCase("-conf") || stringArray[n].equalsIgnoreCase("-config") || stringArray[n].equalsIgnoreCase("-configs") || stringArray[n].equalsIgnoreCase("-configuratoin")) {
                prefs.putString("conf", stringArray[++n]);
            } else if (stringArray[n].equalsIgnoreCase("-dir")) {
                prefs.putString("dir", stringArray[++n]);
            } else if (stringArray[n].equalsIgnoreCase("-httpProxyHost")) {
                prefs.putString("httpProxyHost", stringArray[++n]);
            } else if (stringArray[n].equalsIgnoreCase("-httpProxyPort")) {
                try {
                    prefs.putInteger("httpProxyPort", Integer.parseInt(stringArray[++n]));
                }
                catch (Exception exception) {
                    System.out.println("invalid httpProxyPort: " + stringArray[n]);
                    System.exit(1);
                }
            } else if (stringArray[n].equalsIgnoreCase("-nw")) {
                prefs.putBoolean("noWindow", true);
            } else if (stringArray[n].equalsIgnoreCase("-v") || stringArray[n].equalsIgnoreCase("-version") || stringArray[n].equalsIgnoreCase("--version")) {
                Main.systemInfo();
                System.exit(0);
            } else if (stringArray[n].equalsIgnoreCase("-help") || stringArray[n].equalsIgnoreCase("--help") || stringArray[n].equalsIgnoreCase("-h")) {
                System.out.println("usage: java muffin.Main [options]\n\n-conf NAME            Default configuration.\n-dir DIR              Preferences directory.\n-help                 This useful message.\n-httpProxyHost HOST   Use HOST as the HTTP proxy.\n-httpProxyPort PORT   Use PORT as the HTTP proxy port.\n-nw                   Don't create any windows.\n-port PORT            Listen on PORT for browser requests.\n-v                    Display muffin version.\n");
                System.exit(1);
            } else {
                System.out.println("Unknown option: " + stringArray[n]);
                System.exit(1);
            }
            ++n;
        }
        configs = new Configuration();
        if (prefs.exists("dir")) {
            configs.setUserDirectory(prefs.getString("dir"));
        }
        configs.load();
        configs.scan();
        String string = "default.conf";
        if (prefs.exists("conf")) {
            string = prefs.getString("conf");
        }
        configs.setDefault(string);
        configs.setCurrent(string);
        options = new Options(configs);
        options.putString("muffin.version", version);
        options.putString("muffin.url", "http://muffin.doit.org/");
        try {
            options.putString("muffin.host", InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            options.putString("muffin.host", "127.0.0.1");
        }
        if (prefs.exists("port")) {
            options.putInteger("muffin.port", prefs.getInteger("port"));
        }
        if (prefs.exists("httpProxyHost")) {
            options.putString("muffin.httpProxyHost", prefs.getString("httpProxyHost"));
        }
        if (prefs.exists("httpProxyPort")) {
            options.putInteger("muffin.httpProxyPort", prefs.getInteger("httpProxyPort"));
        }
        if (prefs.exists("noWindow")) {
            options.putBoolean("muffin.noWindow", prefs.getBoolean("noWindow"));
        }
        options.sync();
        new Main();
    }
}

