/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import muffin.Client;
import muffin.ContentFilter;
import muffin.Filter;
import muffin.FilterException;
import muffin.FilterManager;
import muffin.Http;
import muffin.HttpError;
import muffin.HttpRelay;
import muffin.Httpd;
import muffin.Monitor;
import muffin.Options;
import muffin.Proxy;
import muffin.RedirectFilter;
import muffin.Reply;
import muffin.ReplyFilter;
import muffin.Request;
import muffin.RequestFilter;
import muffin.io.ByteArray;
import muffin.io.HtmlObjectStream;
import muffin.io.InputObjectStream;
import muffin.io.OutputObjectStream;
import muffin.io.SourceObjectStream;

class Handler
extends Thread {
    ThreadGroup filterGroup;
    Monitor monitor;
    FilterManager manager;
    Options options;
    Client client;
    Socket socket;
    Request request;
    Reply reply;
    HttpRelay http;
    int currentLength;
    int contentLength;
    Filter[] filterList;
    boolean keepAlive = false;

    Handler(ThreadGroup threadGroup, Runnable runnable, Monitor monitor, FilterManager filterManager, Options options) {
        super(threadGroup, runnable);
        this.monitor = monitor;
        this.manager = filterManager;
        this.options = options;
    }

    void doit(Socket socket) {
        this.socket = socket;
        this.start();
    }

    synchronized void close() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.http != null) {
            this.http.close();
        }
    }

    void flush() {
        if (this.client != null) {
            try {
                this.client.getOutputStream().flush();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    void kill() {
        this.monitor.unregister(this);
        this.stop();
    }

    public void run() {
        Thread.currentThread().setName("Handler (" + this.socket.getInetAddress() + ")");
        this.filterGroup = new ThreadGroup("Filters (" + this.socket.getInetAddress() + ")");
        try {
            this.client = new Client(this.socket);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.monitor.register(this);
        do {
            this.request = null;
            this.reply = null;
            this.filterList = null;
            this.monitor.update(this);
            try {
                this.request = this.client.read();
            }
            catch (Exception exception) {
                break;
            }
            this.manager.checkAutoConfig(this.request.getURL());
            this.filterList = this.manager.createFilters();
            try {
                Object object;
                if (!this.request.getURL().startsWith("http://")) {
                    this.request.setURL("http://" + this.options.getString("muffin.host") + ":" + this.options.getString("muffin.port") + this.request.getURL());
                }
                this.monitor.update(this);
                if (!this.options.getBoolean("muffin.passthru")) {
                    object = this.redirect(this.request);
                    if (object != null) {
                        Reply reply = Reply.createRedirect((String)object);
                        this.client.write(reply);
                        break;
                    }
                    this.filter(this.request);
                }
                this.http = ((Request)(object = this.request)).getHost().equalsIgnoreCase(Httpd.options.getString("muffin.host")) && (((Request)object).getPort() == Httpd.options.getInteger("muffin.port") || false) ? new Httpd(this.socket) : (this.options.useProxy() ? new Proxy(this.options.getString("muffin.httpProxyHost"), this.options.getInteger("muffin.httpProxyPort")) : new Http(new URL(this.request.getURL())));
                this.keepAlive = this.doKeepAlive(this.request);
                this.http.write(this.request);
                this.reply = this.http.read();
                this.monitor.update(this);
                if (this.keepAlive) {
                    this.keepAlive = this.doKeepAlive(this.request, this.reply);
                }
                if (!this.options.getBoolean("muffin.passthru")) {
                    this.filter(this.reply);
                }
                this.monitor.update(this);
                try {
                    this.contentLength = Integer.parseInt(this.reply.getHeaderField("Content-length"));
                }
                catch (Exception exception) {
                    this.contentLength = 0;
                }
                this.currentLength = 0;
                this.monitor.update(this);
                if (this.reply.hasContent()) {
                    if (!this.options.getBoolean("muffin.passthru")) {
                        this.filter(this.http.getInputStream(), this.client.getOutputStream());
                        continue;
                    }
                    this.client.write(this.reply);
                    this.copy(this.http.getInputStream(), this.client.getOutputStream(), true);
                    continue;
                }
                this.client.write(this.reply);
            }
            catch (Exception exception) {
                this.error(this.client.getOutputStream(), exception, this.request);
                this.keepAlive = false;
            }
        } while (this.keepAlive);
        this.close();
        this.monitor.unregister(this);
    }

    boolean doKeepAlive(Request request) {
        boolean bl = false;
        if (request.containsHeaderField("Connection")) {
            if (request.getHeaderField("Connection").equals("open")) {
                bl = true;
            } else if (request.getHeaderField("Connection").equals("close")) {
                bl = false;
            }
            request.removeHeaderField("Connection");
        } else if (request.getProtocol().equals("HTTP/1.1")) {
            bl = true;
        } else if (request.containsHeaderField("Proxy-Connection") && request.getHeaderField("Proxy-Connection").equals("Keep-Alive")) {
            bl = true;
            request.removeHeaderField("Proxy-Connection");
        }
        return bl;
    }

    boolean doKeepAlive(Request request, Reply reply) {
        boolean bl = false;
        reply.removeHeaderField("Connection");
        reply.removeHeaderField("Proxy-Connection");
        if (reply.containsHeaderField("Content-length")) {
            if (request.getProtocol().equals("HTTP/1.1")) {
                reply.setHeaderField("Connection", "open");
            } else {
                reply.setHeaderField("Proxy-Connection", "Keep-Alive");
            }
            bl = true;
        }
        return bl;
    }

    String redirect(Request request) {
        int n = 0;
        while (n < this.filterList.length) {
            RedirectFilter redirectFilter;
            if (this.filterList[n] instanceof RedirectFilter && (redirectFilter = (RedirectFilter)this.filterList[n]).needsRedirection(request)) {
                String string = redirectFilter.redirect(request);
                return string;
            }
            ++n;
        }
        return null;
    }

    void filter(Reply reply) throws FilterException {
        int n = 0;
        while (n < this.filterList.length) {
            if (this.filterList[n] instanceof ReplyFilter) {
                ((ReplyFilter)this.filterList[n]).filter(reply);
            }
            ++n;
        }
    }

    void filter(Request request) throws FilterException {
        int n = 0;
        while (n < this.filterList.length) {
            if (this.filterList[n] instanceof RequestFilter) {
                ((RequestFilter)this.filterList[n]).filter(request);
            }
            ++n;
        }
    }

    void filter(InputStream inputStream, OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        Runnable runnable;
        Object object3 = new InputObjectStream();
        boolean bl = false;
        SourceObjectStream sourceObjectStream = this.reply.containsHeaderField("Content-type") && this.reply.getContentType().equals("text/html") ? new HtmlObjectStream((InputObjectStream)object3) : new SourceObjectStream((InputObjectStream)object3);
        int n = 0;
        while (n < this.filterList.length) {
            if (this.filterList[n] instanceof ContentFilter && (runnable = (ContentFilter)this.filterList[n]).needsFiltration(this.request, this.reply)) {
                OutputObjectStream outputObjectStream = new OutputObjectStream();
                object2 = new InputObjectStream(outputObjectStream);
                runnable.setInputObjectStream((InputObjectStream)object3);
                runnable.setOutputObjectStream(outputObjectStream);
                object = new Thread(this.filterGroup, runnable);
                try {
                    ((Thread)object).setPriority(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ((Thread)object).start();
                object3 = object2;
                bl = true;
            }
            ++n;
        }
        if (bl) {
            sourceObjectStream.setSourceInputStream(inputStream);
            runnable = new Thread(sourceObjectStream);
            ((Thread)runnable).setName("ObjectStream Source (" + this.socket.getInetAddress() + ")");
            ((Thread)runnable).start();
            int n2 = this.contentLength > 0 ? this.contentLength : 8192;
            object2 = new ByteArrayOutputStream(n2);
            this.copy((InputObjectStream)object3, (OutputStream)object2, true);
            object = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
            if (this.reply.containsHeaderField("Content-length")) {
                this.reply.setHeaderField("Content-length", ((ByteArrayOutputStream)object2).size());
            }
            this.client.write(this.reply);
            this.copy((InputStream)object, outputStream, false);
            return;
        }
        this.client.write(this.reply);
        this.copy(inputStream, outputStream, true);
    }

    int getTotalBytes() {
        if (this.contentLength > 0) {
            return this.contentLength;
        }
        return 0;
    }

    int getCurrentBytes() {
        return this.currentLength;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.socket.getInetAddress());
        stringBuffer.append(" - ");
        if (this.keepAlive && this.request == null) {
            stringBuffer.append("Keep-Alive");
        } else if (this.request != null) {
            if (this.reply != null) {
                stringBuffer.append("(");
                stringBuffer.append(this.currentLength);
                if (this.contentLength > 0) {
                    stringBuffer.append("/");
                    stringBuffer.append(this.contentLength);
                }
                stringBuffer.append(") ");
            }
            stringBuffer.append(this.request.getCommand());
            stringBuffer.append(" ");
            stringBuffer.append(this.request.getURL());
        }
        return stringBuffer.toString();
    }

    void error(OutputStream outputStream, Exception exception, Request request) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("While trying to retrieve the URL: <a href=\"" + request.getURL() + "\">" + request.getURL() + "</a>\r\n");
        stringBuffer.append("<p>\r\nThe following error was encountered:\r\n<p>\r\n");
        stringBuffer.append("<ul><li>" + exception.toString() + "</ul>\r\n");
        String string = new HttpError(this.options, 400, stringBuffer.toString()).toString();
        try {
            outputStream.write(string.getBytes(), 0, string.length());
            outputStream.flush();
            return;
        }
        catch (Exception exception2) {
            return;
        }
    }

    void copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n);
            if (!bl) continue;
            this.currentLength += n;
            this.monitor.update(this);
        }
        outputStream.flush();
    }

    void copy(InputObjectStream inputObjectStream, OutputStream outputStream, boolean bl) throws IOException {
        Object object;
        while ((object = inputObjectStream.read()) != null) {
            Object object2;
            if (object instanceof ByteArray) {
                object2 = (ByteArray)object;
                outputStream.write(((ByteArray)object2).getBytes(), 0, ((ByteArray)object2).length());
                this.currentLength += ((ByteArray)object2).length();
            } else if (object instanceof Byte) {
                object2 = (Byte)object;
                outputStream.write(((Byte)object2).byteValue());
                ++this.currentLength;
            } else {
                System.out.println("Unknown object: " + object.toString());
            }
            if (!bl) continue;
            this.monitor.update(this);
        }
        outputStream.flush();
    }
}

