/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.util.Hashtable;
import java.util.Vector;
import muffin.Configuration;
import muffin.ConfigurationListener;
import muffin.Filter;
import muffin.FilterFactory;
import muffin.FilterManagerFrame;
import muffin.Options;
import muffin.Prefs;
import muffin.UserPrefs;

public class FilterManager
implements ConfigurationListener {
    final String[] defaultKnownList = new String[]{"muffin.filter.AnimationKiller", "muffin.filter.CookieMonster", "muffin.filter.Decaf", "muffin.filter.DocumentInfo", "muffin.filter.ForwardedFor", "muffin.filter.Glossary", "muffin.filter.HostnameExpander", "muffin.filter.Logger", "muffin.filter.Painter", "muffin.filter.Preview", "muffin.filter.NoThanks", "muffin.filter.Referer", "muffin.filter.Secretary", "muffin.filter.SecretAgent", "muffin.filter.SecretServer", "muffin.filter.Snoop", "muffin.filter.Stats"};
    Options options;
    Configuration configs;
    FilterManagerFrame frame;
    UserPrefs userPrefs;
    Vector knownFilters;
    Vector enabledFilters;
    Hashtable knownFiltersCache;
    Hashtable enabledFiltersCache;

    FilterManager(Options options, Configuration configuration) {
        this.options = options;
        this.configs = configuration;
        this.knownFiltersCache = new Hashtable();
        this.enabledFiltersCache = new Hashtable();
        configuration.addConfigurationListener(this);
    }

    public void configurationChanged(String string) {
        int n;
        String[] stringArray;
        this.userPrefs = this.configs.getUserPrefs();
        if (!this.knownFiltersCache.containsKey(this.configs.getCurrent())) {
            this.knownFilters = new Vector(32);
            this.knownFiltersCache.put(this.configs.getCurrent(), this.knownFilters);
            stringArray = this.userPrefs.getStringList("muffin.knownFilters");
            if (stringArray.length == 0) {
                stringArray = this.defaultKnownList;
            }
            n = 0;
            while (n < stringArray.length) {
                this.knownFilters.addElement(stringArray[n]);
                ++n;
            }
        } else {
            this.knownFilters = (Vector)this.knownFiltersCache.get(this.configs.getCurrent());
        }
        if (!this.enabledFiltersCache.containsKey(this.configs.getCurrent())) {
            this.enabledFilters = new Vector(32);
            this.enabledFiltersCache.put(this.configs.getCurrent(), this.enabledFilters);
            stringArray = this.userPrefs.getStringList("muffin.enabledFilters");
            n = 0;
            while (n < stringArray.length) {
                this.enable(stringArray[n]);
                ++n;
            }
            return;
        }
        this.enabledFilters = (Vector)this.enabledFiltersCache.get(this.configs.getCurrent());
    }

    void checkAutoConfig(String string) {
        String string2 = this.configs.autoConfig(string);
        if (!string2.equals(this.configs.getCurrent())) {
            System.out.println("Automatic change to " + string2);
            this.configs.setCurrent(string2);
        }
    }

    Filter[] createFilters() {
        Filter[] filterArray = new Filter[this.enabledFilters.size()];
        int n = 0;
        while (n < filterArray.length) {
            FilterFactory filterFactory = (FilterFactory)this.enabledFilters.elementAt(n);
            filterArray[n] = filterFactory.createFilter();
            ++n;
        }
        return filterArray;
    }

    void createFrame() {
        if (this.frame == null) {
            this.frame = new FilterManagerFrame(this);
        }
        this.frame.hideshow();
    }

    void append(String string) {
        this.knownFilters.addElement(string);
        if (this.frame != null) {
            this.frame.updateKnownFiltersList();
        }
    }

    void remove(String string) {
        int n = 0;
        while (n < this.knownFilters.size()) {
            String string2 = (String)this.knownFilters.elementAt(n);
            if (string2.equals(string)) {
                this.knownFilters.removeElementAt(n);
            }
            ++n;
        }
        if (this.frame != null) {
            this.frame.updateKnownFiltersList();
        }
    }

    void enable(String string) {
        try {
            FilterFactory filterFactory = (FilterFactory)Class.forName(string).newInstance();
            Prefs prefs = this.userPrefs.extract(string.substring(string.lastIndexOf(46) + 1));
            filterFactory.setPrefs(prefs);
            filterFactory.setManager(this);
            this.enabledFilters.addElement(filterFactory);
            if (this.frame != null) {
                this.frame.updateEnabledFiltersList();
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("");
            System.out.println("WARNING: Can't load " + string + ": ");
            System.out.println("");
            System.out.println("         " + exception);
            System.out.println("");
            System.out.println("         You may need to restart muffin with a different CLASSPATH.");
            System.out.println("");
        }
    }

    void disable(int n) {
        FilterFactory filterFactory = (FilterFactory)this.enabledFilters.elementAt(n);
        filterFactory.shutdown();
        this.enabledFilters.removeElementAt(n);
        if (this.frame != null) {
            this.frame.updateEnabledFiltersList();
        }
    }

    void disableAll() {
        int n = this.enabledFilters.size() - 1;
        while (n >= 0) {
            this.disable(n);
            --n;
        }
    }

    void save() {
        String[] stringArray = new String[this.enabledFilters.size()];
        int n = 0;
        while (n < stringArray.length) {
            FilterFactory filterFactory = (FilterFactory)this.enabledFilters.elementAt(n);
            stringArray[n] = filterFactory.getClass().getName();
            ++n;
        }
        this.userPrefs.putStringList("muffin.enabledFilters", stringArray);
        this.userPrefs.save();
    }

    public void save(FilterFactory filterFactory) {
        this.userPrefs.merge(filterFactory.getPrefs());
        this.userPrefs.save();
    }
}

