/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

class Connection {
    private final int bufferSize = 8192;
    Socket socket;
    InputStream in;
    OutputStream out;

    Connection(Socket socket) throws IOException {
        this.socket = socket;
        this.in = new BufferedInputStream(socket.getInputStream(), 8192);
        this.out = new BufferedOutputStream(socket.getOutputStream(), 8192);
    }

    Connection(String string, int n) throws IOException {
        this.socket = new Socket(string, n);
        this.in = new BufferedInputStream(this.socket.getInputStream(), 8192);
        this.out = new BufferedOutputStream(this.socket.getOutputStream(), 8192);
    }

    Connection() {
    }

    InputStream getInputStream() {
        return this.in;
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    void close() {
        if (this.socket != null) {
            try {
                Socket socket = this.socket;
                socket.close();
                return;
            }
            catch (Exception exception) {
                System.out.println("Connection: " + exception);
                return;
            }
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }
}

