/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import JP.ac.osaka_u.ender.util.regex.MatchInfo;
import JP.ac.osaka_u.ender.util.regex.RegExp;
import java.awt.Choice;
import java.awt.Label;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import muffin.ConfFileFilter;
import muffin.ConfigurationFrame;
import muffin.ConfigurationListener;
import muffin.Prefs;
import muffin.UserPrefs;

class Configuration
extends Prefs {
    final String autoConfigFile = "autoconfig";
    String currentConfig;
    String defaultConfig;
    Vector autoConfigPatterns = new Vector();
    Vector autoConfigNames = new Vector();
    ConfigurationFrame frame;
    Vector configurationListeners = new Vector();

    Configuration() {
    }

    void addConfigurationListener(Object object) {
        this.configurationListeners.addElement(object);
        this.updateConfigurationListener(object);
    }

    synchronized void updateConfigurationListener(Object object) {
        if (object instanceof Label) {
            Label label = (Label)object;
            label.setText("Current Configuration: " + this.getCurrent());
            label.doLayout();
            return;
        }
        if (object instanceof Choice) {
            Choice choice = (Choice)object;
            choice.select(this.getCurrent());
            return;
        }
        if (object instanceof ConfigurationListener) {
            ConfigurationListener configurationListener = (ConfigurationListener)object;
            configurationListener.configurationChanged(this.getCurrent());
        }
    }

    void updateConfigurationListeners() {
        int n = 0;
        while (n < this.configurationListeners.size()) {
            Object e = this.configurationListeners.elementAt(n);
            this.updateConfigurationListener(e);
            ++n;
        }
    }

    void setDefault(String string) {
        this.defaultConfig = string;
    }

    String getDefault() {
        return this.defaultConfig;
    }

    synchronized void setCurrent(String string) {
        this.currentConfig = string;
        if (!this.exists(this.currentConfig)) {
            this.createConfig(this.currentConfig);
        }
        this.updateConfigurationListeners();
    }

    String getCurrent() {
        return this.currentConfig;
    }

    void createConfig(String string) {
        if (!string.endsWith(".conf")) {
            string = String.valueOf(string) + ".conf";
        }
        System.out.println("Creating new configuration: " + string);
        UserPrefs userPrefs = new UserPrefs(string);
        userPrefs.setUserDirectory(this.getUserDirectory());
        this.put(string, userPrefs);
        this.updateConfigurationListeners();
    }

    UserPrefs getUserPrefs() {
        UserPrefs userPrefs = (UserPrefs)this.get(this.currentConfig);
        userPrefs.load();
        return userPrefs;
    }

    String autoConfig(String string) {
        int n = 0;
        while (n < this.autoConfigPatterns.size()) {
            RegExp regExp = (RegExp)this.autoConfigPatterns.elementAt(n);
            MatchInfo matchInfo = regExp.match(string);
            if (matchInfo != null) {
                return (String)this.autoConfigNames.elementAt(n);
            }
            ++n;
        }
        return this.defaultConfig;
    }

    String getAutoConfigFile() {
        return this.getUserFile("autoconfig");
    }

    String getUserConfigFile(String string) {
        return this.getUserFile(string);
    }

    boolean deleteUserConfigFile(String string) {
        File file = new File(this.getUserConfigFile(string));
        return file.delete();
    }

    boolean delete(String string) {
        if (string.equals(this.getDefault())) {
            System.out.println("Can't delete default configuration");
            return false;
        }
        this.remove(string);
        if (string.equals(this.getCurrent())) {
            this.setCurrent(this.getDefault());
        }
        return true;
    }

    void load(Reader reader) {
        this.autoConfigPatterns = new Vector();
        this.autoConfigNames = new Vector();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                RegExp regExp = new RegExp(string2);
                this.autoConfigPatterns.addElement(regExp);
                this.autoConfigNames.addElement(string3);
            }
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    void load() {
        File file = new File(this.getAutoConfigFile());
        if (!file.exists()) {
            System.out.println(String.valueOf(file.getAbsolutePath()) + " does not exist");
            return;
        }
        System.out.println("Using " + file.getAbsolutePath());
        try {
            this.load(new FileReader(file));
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    void reload() {
        this.load();
        if (this.frame != null) {
            this.frame.loadAutoConfigFile();
        }
    }

    void rescan() {
        this.clear();
        this.scan();
    }

    void scan() {
        File file = new File(this.getUserDirectory());
        if (!file.exists()) {
            return;
        }
        String[] stringArray = file.list(new ConfFileFilter());
        int n = 0;
        while (n < stringArray.length) {
            UserPrefs userPrefs = new UserPrefs(stringArray[n]);
            userPrefs.setUserDirectory(this.getUserDirectory());
            this.put(stringArray[n], userPrefs);
            ++n;
        }
    }

    void createFrame() {
        if (this.frame == null) {
            this.frame = new ConfigurationFrame(this);
        }
        this.frame.show();
    }
}

