/*
 * Decompiled with CFR 0.152.
 */
package JP.ac.osaka_u.ender.util.regex;

import JP.ac.osaka_u.ender.util.regex.Chars;

class RTree {
    public static final int OP_EMPTY = 0;
    public static final int OP_CHAR = 1;
    public static final int OP_CONCAT = 2;
    public static final int OP_UNION = 3;
    public static final int OP_CLOSURE = 4;
    public static final int OP_LHEAD = 5;
    public static final int OP_LTAIL = 6;
    private int operation;
    private Chars chars;
    private RTree left;
    private RTree right;

    public RTree(Chars chars) {
        this(1, chars, null, null);
    }

    public RTree(int n, RTree rTree, RTree rTree2) {
        this(n, null, rTree, rTree2);
    }

    public RTree(int n, Chars chars, RTree rTree, RTree rTree2) {
        this.operation = n;
        this.chars = chars;
        this.left = rTree;
        this.right = rTree2;
    }

    public int operation() {
        return this.operation;
    }

    public Chars chars() {
        return this.chars;
    }

    public RTree left() {
        return this.left;
    }

    public RTree right() {
        return this.right;
    }

    public void removeChars(Chars chars) {
        if (this.operation == 1 && this.chars.hasChars(chars)) {
            if (chars.begin() <= this.chars.begin() && this.chars.end() <= chars.end()) {
                this.chars.setType(4);
                return;
            }
            if (chars.begin() <= this.chars.end() && this.chars.end() <= chars.end()) {
                this.chars.setEnd((char)(chars.begin() - '\u0001'));
            } else if (chars.begin() <= this.chars.begin() && this.chars.begin() <= chars.end()) {
                this.chars.setBegin((char)(chars.end() + '\u0001'));
            } else if (this.chars.begin() <= chars.begin() && chars.end() <= this.chars.end()) {
                this.operation = 3;
                this.left = new RTree(new Chars(this.chars.begin(), (char)(chars.begin() - '\u0001')));
                this.right = new RTree(new Chars((char)(chars.end() + '\u0001'), this.chars.end()));
            }
        }
        if (this.left != null) {
            this.left.removeChars(chars);
        }
        if (this.right != null) {
            this.right.removeChars(chars);
        }
    }
}

