
interface Comparator
	{
	/**
	 * Returns an integer that is less than, equal to, 
	 * or greater than zero. The integer's value depends on whether 
	 * leftOperand is less than, equal to, or greater than rightOperand. 
	 */
	public int compare( Object leftOperand, Object rightOperand );
	
	/**
	 * Returns true if the leftOperand is less than the rightOperand.
	 */
	public boolean lessThan( Object leftOperand, Object rightOperand );

	/**
	 * Returns true if the leftOperand is greater than the rightOperand.
	 */
	public boolean greaterThan( Object leftOperand, Object rightOperand );

	/**
	 * Returns true if the leftOperand is equal to the rightOperand.
	 */
	public boolean equal( Object leftOperand, Object rightOperand );

	/**
	 * Returns true if the leftOperand is less than or equal to the rightOperand.
	 */
	public boolean lessThanOrEqual( Object leftOperand, Object rightOperand );

	/**
	 * Returns true if the leftOperand is greater than or equal the rightOperand.
	 */
	public boolean greaterThanOrEqual( Object leftOperand, Object rightOperand );
	}