/* SecretaryFrame.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filter;

import java.awt.*;
import java.awt.event.*;
import muffin.*;

import java.util.Enumeration;

public class SecretaryFrame extends Frame implements ActionListener, WindowListener, ItemListener
{
  Prefs prefs;
  Secretary parent;
    
  TextField input = null;
    
  private Choice Attributes = null;
  private Choice Aliases = null;
  private TextField Value = null;

  public SecretaryFrame (Prefs prefs, Secretary parent)
  {
    super ("Secretary");

    this.prefs = prefs;
    this.parent = parent;

    setBackground (Color.lightGray);
    setFont (new Font ("Helvetica", Font.BOLD, 12));

    Panel panel = new Panel ();
    GridBagLayout layout = new GridBagLayout ();
    panel.setLayout (layout);

    GridBagConstraints gbc;
	
    //	panel.add (new Label ("Form File:", Label.RIGHT));

    //	input = new TextField (50);
    //	input.setText (prefs.getString ("Secretary.formfile"));
    //	panel.add (input);

    //	Button browse = new Button ("Browse...");
    //	browse.setActionCommand ("doBrowse");
    //	browse.addActionListener (this);
    //	panel.add (browse);

    Label label = new Label ("Attribute:", Label.RIGHT);

    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.RELATIVE;
    gbc.anchor = GridBagConstraints.EAST;

    layout.setConstraints(label, gbc);
    panel.add(label);
	
    Choice Attributes = new Choice();
    this.Attributes = Attributes;
    Attributes.addItemListener(this);

    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbc.anchor = GridBagConstraints.WEST;
	
    for (Enumeration e = parent.Values.keys();e.hasMoreElements();) {
      Attributes.add((String) e.nextElement());
    }

    layout.setConstraints(Attributes, gbc);
    panel.add(Attributes);

    label = new Label("Alias:", Label.RIGHT);
	
    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.RELATIVE;
    gbc.anchor = GridBagConstraints.EAST;
	
    layout.setConstraints(label, gbc);
    panel.add(label);

    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbc.anchor = GridBagConstraints.WEST;
	
    Aliases = new Choice();
    this.Aliases = Aliases;
    Aliases.addItemListener(this);
    Aliases.add("Hello");
    Aliases.add("Huhu");
    layout.setConstraints(Aliases, gbc);
    panel.add(Aliases);

    label = new Label("Value:", Label.RIGHT);

    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.RELATIVE;
    gbc.anchor = GridBagConstraints.EAST;

    layout.setConstraints(label, gbc);
    panel.add(label);

    TextField text = new TextField("", 30);
    //label = new Label("                  ", Label.LEFT);
    this.Value = text;
    text.setEditable(false);

    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbc.anchor = GridBagConstraints.WEST;

    layout.setConstraints(text, gbc);
    panel.add(text);

    label = new Label("Input:", Label.RIGHT);
	
    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.RELATIVE;
    gbc.anchor = GridBagConstraints.EAST;

    layout.setConstraints(label, gbc);
    panel.add(label);

    text = new TextField("", 30);
    this.input = text;
    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbc.anchor = GridBagConstraints.WEST;
	
    layout.setConstraints(text, gbc);
    panel.add(text);
	
    add ("North", panel);

    // here starts the button panel
    panel = new Panel();
    layout = new GridBagLayout();
    panel.setLayout(layout);

    label = new Label("Add", Label.LEFT);

    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbc.fill = GridBagConstraints.HORIZONTAL;
    gbc.anchor = GridBagConstraints.WEST;
    layout.setConstraints(label, gbc);
    panel.add(label);

    Button button = new Button("Attribute");
    button.setActionCommand("doAddAttribute");
    button.addActionListener(this);

    gbc = new GridBagConstraints();
    gbc.gridx = 1;
    gbc.gridwidth = GridBagConstraints.RELATIVE;
    gbc.anchor = GridBagConstraints.WEST;
    layout.setConstraints(button, gbc);
    panel.add(button);
	
    button = new Button("Alias");
    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.RELATIVE;
    gbc.anchor = GridBagConstraints.WEST;
    layout.setConstraints(button, gbc);
    panel.add(button);
	
    button = new Button("Value");
    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    button.addActionListener(this);
    button.setActionCommand("doAddValue");
    layout.setConstraints(button, gbc);
    panel.add(button);
	
    label = new Label("Modify", Label.LEFT);
    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbc.fill = GridBagConstraints.HORIZONTAL;
    gbc.anchor = GridBagConstraints.WEST;
    layout.setConstraints(label, gbc);
    panel.add(label);

    button = new Button("Attribute");
    gbc = new GridBagConstraints();
    gbc.gridx = 1;
    gbc.gridwidth = GridBagConstraints.RELATIVE;
    layout.setConstraints(button, gbc);
    panel.add(button);
	
    button = new Button("Alias");
    gbc = new GridBagConstraints();
    //    gbc.gridwidth = GridBagConstraints.RELATIVE;
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbc.anchor = GridBagConstraints.WEST;
    layout.setConstraints(button, gbc);
    panel.add(button);
	
    //    button = new Button("Value");
    //    gbc = new GridBagConstraints();
    //    gbc.gridwidth = GridBagConstraints.REMAINDER;
    //    layout.setConstraints(button, gbc);
    //    panel.add(button);
	
    label = new Label("Delete", Label.LEFT);
    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbc.fill = GridBagConstraints.HORIZONTAL;
    gbc.anchor = GridBagConstraints.WEST;
    layout.setConstraints(label, gbc);
    panel.add(label);

    button = new Button("Attribute");
    gbc = new GridBagConstraints();
    gbc.gridx = 1;
    gbc.gridwidth = GridBagConstraints.RELATIVE;
    layout.setConstraints(button, gbc);
    panel.add(button);
	
    button = new Button("Alias");
    gbc = new GridBagConstraints();
    gbc.gridwidth = GridBagConstraints.REMAINDER;
    gbc.anchor = GridBagConstraints.WEST;
    layout.setConstraints(button, gbc);
    panel.add(button);
	

	

    add("Center", panel);
	

    // here starts the command button panel
    Panel buttonPanel = new Panel ();
    buttonPanel.setLayout (new GridLayout (1, 4));
    Button b;
    b = new Button ("Apply");
    b.setActionCommand ("doApply");
    b.addActionListener (this);
    buttonPanel.add (b);
    b = new Button ("Save");
    b.setActionCommand ("doSave");
    b.addActionListener (this);
    buttonPanel.add (b);
    b = new Button ("Reload File");
    b.setActionCommand ("doReload");
    b.addActionListener (this);
    buttonPanel.add (b);
    b = new Button ("Close");
    b.setActionCommand ("doClose");
    b.addActionListener (this);
    buttonPanel.add (b);
    add ("South", buttonPanel);

    addWindowListener (this);
	
    String[] attributes = prefs.getStringList("Secretary.Names");
    setAttribute(attributes[0]);
    Attributes.select(attributes[0]);

    pack ();
    setSize (getPreferredSize ());

    show ();
  }

  public void actionPerformed (ActionEvent event)
  {
    String arg = event.getActionCommand ();
    System.out.println(event);
	
    if ("doApply".equals (arg))
      {
	prefs.putString ("Secretary.formfile", input.getText ());
      }
    else if ("doSave".equals (arg))
      {
	parent.save ();
      }
    else if ("doReload".equals (arg))
      {
	parent.load ();
      }
    else if ("doClose".equals (arg))
      {
	setVisible (false);
      }
    // button processing
    else if ("doAddValue".equals (arg))
      {
	this.setValue();
      }
    else if ("doAddAttribute".equals (arg)) {
      this.addAttribute();
    }
    else if ("doBrowse".equals (arg))
      {
	FileDialog dialog = new FileDialog (this, "Secretary Load");
	dialog.show ();
	if (dialog.getFile () != null)
	  {
	    input.setText (dialog.getDirectory () + dialog.getFile ());
	  }
      }
  }

  public void windowActivated (WindowEvent e)
  {
  }
  
  public void windowDeactivated (WindowEvent e)
  {
  }
  
  public void windowClosing (WindowEvent e)
  {
    setVisible (false);
  }
  
  public void windowClosed (WindowEvent e)
  {
  }
  
  public void windowIconified (WindowEvent e)
  {
  }
  
  public void windowDeiconified (WindowEvent e)
  {
  }
  
  public void windowOpened (WindowEvent e)
  {
  }

  // implementation of the ItemListener interface

  public void itemStateChanged(ItemEvent e) {
    String item = (String) e.getItem();
    Choice c = (Choice) e.getItemSelectable();

    if(c.equals(Attributes)) {
      setAttribute(item);
    }
  }

  private void setAttribute(String item) {
    String[] items = prefs.getStringList(new String("Secretary.Aliases.").concat(item));

    Aliases.removeAll();
    for(int i = 0; i<items.length; i++) {
      Aliases.add(items[i]);
    }

    String value = prefs.getString(new String("Secretary.").concat(item));
    Value.setText(value);
  }

  private void setValue() {
    String item = Attributes.getSelectedItem();
    String value = input.getText();
    prefs.putString(new String("Secretary.").concat(item), value);
    Value.setText(value);
  }

  private void addAttribute() {
    System.out.println("addAttribute");
    String value = input.getText().toLowerCase();
    
    System.out.println(value);


    String[] attributes = prefs.getStringList("Secretary.Names");

    String[] newattributes = new String[attributes.length + 1];
    for (int i = 0; i < attributes.length; i++) {
      newattributes[i] = attributes[i];
    }
    newattributes[attributes.length] = value;

    // add the name to the list
    prefs.putStringList("Secretary.Names", newattributes);
    // add an empty value
    prefs.putString(new String("Secretary.").concat(value), "");
    // add the aliases
    prefs.putString(new String("Secretary.Aliases.").concat(value), value);

    Attributes.removeAll();
    for (int i = 0; i < newattributes.length; i++) {
      Attributes.add(newattributes[i]);
    }
    Attributes.select(value);
    setAttribute(value);
  }
  
}
