/* PainterFilter.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filter;

import muffin.*;
import muffin.html.*;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class PainterFilter implements ContentFilter
{
    Painter factory;
    Prefs prefs;
    InputStream in = null;
    OutputStream out = null;
    Request request = null;

    PainterFilter (Painter factory)
    {
	this.factory = factory;
    }
    
    public void setPrefs (Prefs prefs)
    {
	this.prefs = prefs;
    }

    public boolean needsFiltration (Request request, Reply reply)
    {
	this.request = request;
	String s = reply.getHeaderField ("Content-type");
	return s != null && s.startsWith ("text/html");
    }
    
    public void setInputStream (InputStream in)
    {
	this.in = in;
    }

    public void setOutputStream (OutputStream out)
    {
	this.out = out;
    }
    
    public void run ()
    {
	try
	{
	    HtmlTokenizer html = new HtmlTokenizer (in);
	    int token;
	    Tag tag;

            while ((token = html.getToken ()) != HtmlTokenizer.TT_EOF)
            {
		if (token == HtmlTokenizer.TT_TAG)
		{
		    tag = html.getTag ();

		    /* <body> */
		    if (tag.is ("body"))
		    {
			String value;

			value = prefs.getString ("Painter.bgcolor");
			if (value.length () > 0)
			{
			    if (value.equalsIgnoreCase ("None"))
			    {
				tag.remove ("bgcolor");
				tag.remove ("background");
			    }
			    else
			    {
				tag.put ("bgcolor", value);
				tag.remove ("background");
			    }
			}
			else
			{
			    value = prefs.getString ("Painter.background");
			    if (value.length () > 0)
			    {
				if (value.equalsIgnoreCase ("None"))
				{
				    tag.remove ("background");
				    tag.remove ("bgcolor");
				}
				else
				{
				    tag.put ("background", value);
				    tag.remove ("bgcolor");
				}
			    }
			}
			
			value = prefs.getString ("Painter.text");
			if (value.length () > 0)
			{
			    if (value.equalsIgnoreCase ("None"))
			    {
				tag.remove ("text");
			    }
			    else
			    {
				tag.put ("text", value);
			    }
			}

			value = prefs.getString ("Painter.link");
			if (value.length () > 0)
			{
			    if (value.equalsIgnoreCase ("None"))
			    {
				tag.remove ("link");
			    }
			    else
			    {
				tag.put ("link", value);
			    }
			}

			value = prefs.getString ("Painter.alink");
			if (value.length () > 0)
			{
			    if (value.equalsIgnoreCase ("None"))
			    {
				tag.remove ("alink");
			    }
			    else
			    {
				tag.put ("alink", value);
			    }
			}

			value = prefs.getString ("Painter.vlink");
			if (value.length () > 0)
			{
			    if (value.equalsIgnoreCase ("None"))
			    {
				tag.remove ("vlink");
			    }
			    else
			    {
				tag.put ("vlink", value);
			    }
			}
		    }
		    /* <font> */
		    else if (tag.is ("font") && tag.has ("color"))
		    {
			String value = prefs.getString ("Painter.text");
			if (value.length () > 0)
			{
			    if (value.equalsIgnoreCase ("None"))
			    {
				tag.remove ("color");
			    }
			    else
			    {
				tag.put ("color", value);
			    }
			}
		    }
		    /* <table> <tr> <th> <td> */
		    else if ((tag.is ("table") || tag.is ("tr") || tag.is ("th") || tag.is ("td")) && tag.has ("bgcolor"))
		    {
			String value = prefs.getString ("Painter.bgcolor");
			if (value.length () > 0)
			{
			    if (value.equalsIgnoreCase ("None"))
			    {
				tag.remove ("bgcolor");
			    }
			    else
			    {
				tag.put ("bgcolor", value);
			    }
			}
		    }

		    html.writeTag (tag, out);
		}
		else
		{
		    html.writeToken (out);
		}
	    }
	    
	    out.flush ();
	    out.close ();
	}
	catch (Exception e)
	{
	    e.printStackTrace ();
	}
    }
}

