/* Glossary.java  */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filter;

import muffin.*;
import muffin.html.*;

import java.io.File;
import java.io.FileReader;
import java.io.BufferedReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Glossary extends Hashtable implements FilterFactory
{
    FilterManager manager;
    Prefs prefs;
    GlossaryFrame frame = null;

    public Glossary ()
    {
	super (33);
    }

    public void setManager (FilterManager manager)
    {
	this.manager = manager;
    }
    
    public void setPrefs (Prefs prefs)
    {
	this.prefs = prefs;
	boolean o = prefs.getOverride ();
	prefs.setOverride (false);
	String filename = prefs.getUserFile ("glossary");
	prefs.putString ("Glossary.glossaryfile", filename);
	prefs.setOverride (o);
	load ();
    }

    public Prefs getPrefs ()
    {
	return prefs;
    }

    public void viewPrefs ()
    {
	if (frame == null)
	{
	    frame = new GlossaryFrame (prefs, this);
	}
	frame.setVisible (true);
    }
    
    public Filter createFilter ()
    {
	Filter f = new GlossaryFilter (this);
	f.setPrefs (prefs);
	return f;
    }

    void save ()
    {
	manager.save (this);
    }

    String lookup (String term)
    {
	return (String) get (term.toLowerCase ());
    }

    void load ()
    {
	String filename = prefs.getString ("Glossary.glossaryfile");
	System.out.println ("Glossary loading " + filename);
	File file = new File (filename);
	if (!file.exists ())
	{
	    System.out.println ("Glossary can't open " + filename);
	    return;
	}
	try
	{
	    BufferedReader in = new BufferedReader (new FileReader (file));
	    String s;
	    while ((s = in.readLine ()) != null)
	    {
		StringTokenizer st = new StringTokenizer (s, " \t");
		String term = st.nextToken ();
		String url = st.nextToken ();
		put (term.toLowerCase (), url);
	    }
	    in.close ();
	}
	catch (Exception e)
	{
	    e.printStackTrace ();
	}
    }
}
