/* CookieMonsterFilter.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filter;

import muffin.*;

public class CookieMonsterFilter implements RequestFilter, ReplyFilter
{
    Prefs prefs;
    CookieMonster factory;
    Request request = null;

    CookieMonsterFilter (CookieMonster factory)
    {
	this.factory = factory;
    }
    
    public void setPrefs (Prefs prefs)
    {
	this.prefs = prefs;
    }
    
    public void filter (Request r) throws FilterException
    {
	this.request = r;
	
	if (r.containsHeaderField ("Cookie"))
	{
	    if (prefs.getBoolean ("CookieMonster.eatRequestCookies"))
	    {
		String cookie = r.getHeaderField ("Cookie");
		r.removeHeaderField ("Cookie");
	    }
	}
    }
    
    public void filter (Reply r) throws FilterException
    {
	if (r.containsHeaderField ("Set-Cookie"))
	{
	    Cookie cookie = new Cookie (r.getHeaderField ("Set-Cookie"), request);
	    if (prefs.getBoolean ("CookieMonster.eatReplyCookies"))
	    {
		factory.process (cookie);
		r.removeHeaderField ("Set-Cookie");
	    }
	}
    }
}
