/* OptionsFrame.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

/**
 * @author Mark Boyns
 */
public class OptionsFrame extends Frame implements ActionListener, WindowListener
{
    Options options;
    UserPrefs userPrefs;
    TextField httpProxyHost;
    TextField httpProxyPort;
    TextField hostsAllowList;
    TextField hostsDenyList;
    TextField adminAllowList;
    TextField adminDenyList;

    public OptionsFrame (Options options, UserPrefs userPrefs)
    {
	super ("Options");

	this.options = options;
	this.userPrefs = userPrefs;

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
	panel.setLayout (layout);

	Label l;
	TextField t;
	Button b;
	GridBagConstraints c;

	l = new Label ("HTTP Proxy:", Label.RIGHT);
	c = new GridBagConstraints ();
	layout.setConstraints (l, c);
	panel.add (l);

	httpProxyHost = new TextField (20);
	httpProxyHost.setText (options.getString ("muffin.httpProxyHost"));
	c = new GridBagConstraints ();
	layout.setConstraints (httpProxyHost, c);
	panel.add (httpProxyHost);

	l = new Label ("Port:", Label.RIGHT);
	c = new GridBagConstraints ();
	layout.setConstraints (l, c);
	panel.add (l);
	
	httpProxyPort = new TextField (10);
	httpProxyPort.setText (options.getString ("muffin.httpProxyPort"));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (httpProxyPort, c);
	panel.add (httpProxyPort);

	l = new Label ("HostsAllow:", Label.RIGHT);
	c = new GridBagConstraints ();
	layout.setConstraints (l, c);
	panel.add (l);
	
	hostsAllowList = new TextField (50);
	hostsAllowList.setText (options.getString ("muffin.hostsAllow"));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (hostsAllowList, c);
	panel.add (hostsAllowList);

	l = new Label ("HostsDeny:", Label.RIGHT);
	c = new GridBagConstraints ();
	layout.setConstraints (l, c);
	panel.add (l);
	
	hostsDenyList = new TextField (50);
	hostsDenyList.setText (options.getString ("muffin.hostsDeny"));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (hostsDenyList, c);
	panel.add (hostsDenyList);
	
	l = new Label ("AdminAllow:", Label.RIGHT);
	c = new GridBagConstraints ();
	layout.setConstraints (l, c);
	panel.add (l);
	
	adminAllowList = new TextField (50);
	adminAllowList.setText (options.getString ("muffin.adminAllow"));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (adminAllowList, c);
	panel.add (adminAllowList);

	l = new Label ("AdminDeny:", Label.RIGHT);
	c = new GridBagConstraints ();
	layout.setConstraints (l, c);
	panel.add (l);
	
	adminDenyList = new TextField (50);
	adminDenyList.setText (options.getString ("muffin.adminDeny"));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (adminDenyList, c);
	panel.add (adminDenyList);
	add ("Center", panel);

	Panel buttonPanel = new Panel ();
	buttonPanel.setLayout (new GridLayout (1, 2));
	b = new Button ("Apply");
	b.setActionCommand ("doApply");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Save");
	b.setActionCommand ("doSave");
	b.addActionListener (this);
	buttonPanel.add (b);
	b = new Button ("Close");
	b.setActionCommand ("doClose");
	b.addActionListener (this);
	buttonPanel.add (b);
	add ("South", buttonPanel);

	addWindowListener (this);

	pack ();
	setSize (getPreferredSize ());
    }
    
    public void hideshow ()
    {
	if (isShowing ())
	{
	    setVisible (false);
	}
	else
	{
	    show ();
	}
    }

    void sync ()
    {
	options.putString ("muffin.httpProxyHost", httpProxyHost.getText ());
	options.putString ("muffin.httpProxyPort", httpProxyPort.getText ());
	options.putString ("muffin.hostsAllow", hostsAllowList.getText ());
	options.putString ("muffin.hostsDeny", hostsDenyList.getText ());
	options.putString ("muffin.adminAllow", adminAllowList.getText ());
	options.putString ("muffin.adminDeny", adminDenyList.getText ());
	options.sync ();
    }

    public void actionPerformed (ActionEvent event)
    {
	String arg = event.getActionCommand ();

	if ("doApply".equals (arg))
	{
	    sync ();
	}
	else if ("doSave".equals (arg))
	{
	    sync ();
	    userPrefs.putString ("muffin.httpProxyHost", options.getString ("muffin.httpProxyHost"));
	    userPrefs.putString ("muffin.httpProxyPort", options.getString ("muffin.httpProxyPort"));
	    userPrefs.putString ("muffin.hostsAllow", options.getString ("muffin.hostsAllow"));
	    userPrefs.putString ("muffin.hostsDeny", options.getString ("muffin.hostsDeny"));
	    userPrefs.putString ("muffin.adminAllow", options.getString ("muffin.adminAllow"));
	    userPrefs.putString ("muffin.adminDeny", options.getString ("muffin.adminDeny"));
	    userPrefs.save ();
	}
	else if ("doClose".equals (arg))
	{
	    setVisible (false);
	}
    }

    public void windowActivated (WindowEvent e)
    {
    }
  
    public void windowDeactivated (WindowEvent e)
    {
    }
  
    public void windowClosing (WindowEvent e)
    {
	setVisible (false);
    }
  
    public void windowClosed (WindowEvent e)
    {
    }
  
    public void windowIconified (WindowEvent e)
    {
    }
  
    public void windowDeiconified (WindowEvent e)
    {
    }
  
    public void windowOpened (WindowEvent e)
    {
    }
}
