/* ContentFilter.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * Filter interface for content filtering.
 *
 * @see muffin.RequestFilter
 * @see muffin.ReplyFilter
 * @see muffin.Filter
 * @author Mark Boyns
 */
public interface ContentFilter extends Filter, Runnable
{
    /**
     * Specify whether or not this filter is interested
     * in filtering the content related to request and reply.
     *
     * @param request the request
     * @param reply the reply
     */
    public boolean needsFiltration (Request request, Reply reply);

    /**
     * Set the input stream to be used.
     *
     * @param in the input stream
     */
    public void setInputStream (InputStream in);
    
    /**
     * Set the output stream to be used.
     *
     * @param out the output stream
     */
    public void setOutputStream (OutputStream out);
}

