/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import sdsu.util.ConversionException;
import sdsu.util.ListEnumerator;
import sdsu.util.OrderedCollection;
import sdsu.util.ReverseListEnumerator;
import sdsu.util.SimpleTokenizer;
import sdsu.util.Stringizable;
import sdsu.util.Stringizer;
import sdsu.util.TokenCharacters;

public class List
implements OrderedCollection,
Stringizable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private char separatorChar = (char)44;
    private TokenCharacters parseTable = new TokenCharacters(String.valueOf(this.separatorChar));

    public List() {
        this(10);
    }

    public List(int n) {
        this(n, 0);
    }

    public List(int n, int n2) {
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public List(Vector vector) {
        this(vector.size());
        vector.copyInto(this.elementData);
    }

    public void fromString(String string) throws ConversionException {
        this.load(new StringBufferInputStream(string));
    }

    public void load(InputStream inputStream) throws ConversionException {
        try {
            SimpleTokenizer simpleTokenizer = new SimpleTokenizer(inputStream, this.parseTable);
            while (simpleTokenizer.hasMoreTokens()) {
                this.addElement(simpleTokenizer.nextToken());
            }
            return;
        }
        catch (IOException iOException) {
            throw new ConversionException("IO Exception thrown in converting object");
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        Stringizer stringizer = new Stringizer(this.parseTable);
        stringizer.setHeader(string);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stringizer.appendToken(enumeration.nextElement(), this.separatorChar);
        }
        return stringizer.toString();
    }

    public Vector toVector() {
        Vector vector = new Vector(this.elementData.length);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.size());
        return objectArray;
    }

    public void save(OutputStream outputStream, String string) {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println(this.toString(string));
        printStream.flush();
    }

    public void setSeparatorChar(char c) {
        this.separatorChar = c;
        this.upDateParseTable();
    }

    public void setTokenCharacters(TokenCharacters tokenCharacters) {
        this.parseTable = tokenCharacters;
        this.upDateParseTable();
    }

    private void upDateParseTable() {
        this.parseTable.setSeparatorChars(String.valueOf(this.separatorChar));
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            Object[] objectArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new Object[n3];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        } else {
            int n2 = n;
            while (n2 < this.elementCount) {
                this.elementData[n2] = null;
                ++n2;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized Enumeration elements() {
        return new ListEnumerator(this);
    }

    public final synchronized Enumeration elementsReversed() {
        return new ReverseListEnumerator(this);
    }

    public final boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int n) {
        int n2 = n;
        while (n2 < this.elementCount) {
            if (object.equals(this.elementData[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount);
    }

    public synchronized int lastIndexOf(Object object, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            if (!object.equals(this.elementData[n2])) continue;
            return n2;
        }
        return -1;
    }

    public final synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " < 0");
        }
    }

    public final synchronized int intAt(int n) {
        Number number = (Number)this.elementAt(n);
        return number.intValue();
    }

    public final synchronized double doubleAt(int n) {
        Number number = (Number)this.elementAt(n);
        return number.doubleValue();
    }

    public final synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount);
        }
        this.elementData[n] = object;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final synchronized void insertElementAt(Object object, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount + 1);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public synchronized void addElement(Object object) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = object;
    }

    public final synchronized void addElement(int n) {
        this.addElement(new Integer(n));
    }

    public final synchronized void addElement(double d) {
        this.addElement(new Double(d));
    }

    public void addElements(Object[] objectArray) {
        this.ensureCapacity(objectArray.length + this.size());
        System.arraycopy(objectArray, 0, this.elementData, this.size(), objectArray.length);
        this.elementCount += objectArray.length;
    }

    public void addElements(Vector vector) {
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        this.addElements(objectArray);
    }

    public final synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        int n = 0;
        while (n < this.elementCount) {
            this.elementData[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            List list = (List)super.clone();
            list.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, list.elementData, 0, this.elementCount);
            return list;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized OrderedCollection reversed() {
        List list = new List(this.size());
        Enumeration enumeration = this.elementsReversed();
        while (enumeration.hasMoreElements()) {
            list.addElement(enumeration.nextElement());
        }
        return list;
    }

    public synchronized OrderedCollection shuffled() {
        List list = new List(this.size());
        Object[] objectArray = new Object[this.size()];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.size());
        Random random = new Random();
        int n = this.size();
        while (n > 0) {
            int n2 = Math.abs(random.nextInt()) % n;
            list.addElement(objectArray[n2]);
            objectArray[n2] = objectArray[n - 1];
            --n;
        }
        return list;
    }
}

