/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.io.InputStream;
import java.io.OutputStream;
import muffin.ContentFilter;
import muffin.Prefs;
import muffin.Reply;
import muffin.Request;
import muffin.filter.Test;
import muffin.html.HtmlTokenizer;

public class TestFilter
implements ContentFilter {
    Prefs prefs;
    Test factory;
    InputStream in;
    OutputStream out;
    Reply reply;
    Request request;

    public TestFilter(Test test) {
        this.factory = test;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        this.reply = reply;
        String string = reply.getHeaderField("Content-type");
        return string != null && string.startsWith("text/html");
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void xrun() {
        try {
            int n;
            while ((n = this.in.read()) != -1) {
                this.out.write(n);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void run() {
        try {
            int n;
            HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this.in);
            while ((n = htmlTokenizer.getToken()) != -1) {
                if (n == -2) {
                    htmlTokenizer.getTag();
                }
                htmlTokenizer.writeToken(this.out);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

