/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import muffin.Prefs;
import muffin.filter.Stats;

public class StatsFrame
extends Frame
implements ActionListener,
WindowListener {
    Prefs prefs;
    Stats parent;
    TextArea text;

    public StatsFrame(Prefs prefs, Stats stats) {
        super("Stats");
        this.prefs = prefs;
        this.parent = stats;
        ((Component)this).setBackground(Color.lightGray);
        ((Component)this).setFont(new Font("Helvetica", 1, 12));
        this.text = new TextArea();
        this.text.setEditable(false);
        this.add("Center", this.text);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3));
        Button button = new Button("Update");
        button.setActionCommand("doUpdate");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Reset");
        button.setActionCommand("doReset");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Close");
        button.setActionCommand("doClose");
        button.addActionListener(this);
        panel.add(button);
        this.add("South", panel);
        this.addWindowListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
        this.show();
    }

    void reset() {
        this.text.setText("");
        this.parent.reset();
    }

    void print(Hashtable hashtable) {
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n2 = (Integer)hashtable.get(string);
            this.text.append("    " + string + ": " + n2 + "\n");
            n += n2.intValue();
        }
        this.text.append("    TOTAL: " + n + "\n");
    }

    void printUniqueServers() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(100);
        Enumeration enumeration = this.parent.servers.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)this.parent.servers.get(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            if ((string = stringTokenizer.nextToken()).startsWith("Netscape")) {
                string = new String("Netscape");
            }
            if (hashtable.containsKey(string)) {
                Integer n2 = (Integer)hashtable.get(string);
                n2 = new Integer(n2 + n);
                hashtable.put(string, n2);
                continue;
            }
            hashtable.put(string, n);
        }
        this.text.append("Unique Servers: " + hashtable.size() + "\n");
        this.print(hashtable);
        this.text.append("\n");
    }

    void update() {
        this.text.setText("");
        this.text.append("Requests: ");
        this.text.append(String.valueOf(this.parent.requests) + "\n");
        this.text.append("\n");
        this.text.append("Replies: ");
        this.text.append(String.valueOf(this.parent.replies) + "\n");
        this.text.append("\n");
        this.text.append("Hosts: " + this.parent.hosts.size() + "\n");
        this.print(this.parent.hosts);
        this.text.append("\n");
        this.text.append("Servers: " + this.parent.servers.size() + "\n");
        this.print(this.parent.servers);
        this.text.append("\n");
        this.printUniqueServers();
        this.text.append("Content-types:\n");
        this.print(this.parent.contentTypes);
        this.text.append("\n");
        this.text.append("Content-lengths:\n");
        this.print(this.parent.contentLengths);
        this.text.append("\n");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doUpdate".equals(string)) {
            this.update();
            return;
        }
        if ("doReset".equals(string)) {
            this.reset();
            return;
        }
        if ("doClose".equals(string)) {
            ((Component)this).setVisible(false);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

