/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.io.InputStream;
import java.io.OutputStream;
import muffin.ContentFilter;
import muffin.Prefs;
import muffin.Reply;
import muffin.Request;
import muffin.filter.Secretary;
import muffin.html.HtmlTokenizer;
import muffin.html.Tag;

public class SecretaryFilter
implements ContentFilter {
    Secretary factory;
    Prefs prefs;
    InputStream in;
    OutputStream out;
    Request request;

    public SecretaryFilter(Secretary secretary) {
        this.factory = secretary;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        String string = reply.getHeaderField("Content-type");
        return string != null && string.startsWith("text/html");
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void run() {
        try {
            int n;
            HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this.in);
            boolean bl = false;
            String string = null;
            while ((n = htmlTokenizer.getToken()) != -1) {
                if (n == -2) {
                    Tag tag = htmlTokenizer.getTag();
                    if (tag.is("form")) {
                        bl = true;
                    } else if (tag.is("/form")) {
                        bl = false;
                    } else if (tag.is("select")) {
                        if (tag.has("name")) {
                            string = tag.get("name").toLowerCase();
                        }
                    } else if (tag.is("/select")) {
                        string = null;
                    } else if (bl && tag.is("input") && tag.has("name") && (!tag.has("type") || tag.has("type") && tag.get("type").equalsIgnoreCase("text"))) {
                        String string2 = tag.get("name").toLowerCase();
                        if (this.factory.containsKey(string2)) {
                            tag.put("value", (String)this.factory.get(string2));
                        }
                    } else if (bl && tag.is("option") && string != null && this.factory.containsKey(string) && tag.has("value")) {
                        if (tag.has("selected")) {
                            tag.remove("selected");
                        }
                        tag.get("value");
                        if (this.factory.get(string).equals(tag.get("value"))) {
                            tag.put("selected", "");
                        }
                    }
                    htmlTokenizer.writeTag(tag, this.out);
                    continue;
                }
                htmlTokenizer.writeToken(this.out);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

