/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import muffin.ContentFilter;
import muffin.Prefs;
import muffin.Reply;
import muffin.Request;
import muffin.filter.Preview;
import muffin.filter.PreviewDialog;

public class PreviewFilter
implements ContentFilter {
    Preview factory;
    Prefs prefs;
    InputStream in;
    OutputStream out;
    Reply reply;
    Request request;

    PreviewFilter(Preview preview) {
        this.factory = preview;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        this.reply = reply;
        String string = reply.getHeaderField("Content-type");
        if (string == null) {
            return false;
        }
        if (this.prefs.getString("Preview.contentTypes").equals("ALL")) {
            return true;
        }
        String[] stringArray = this.prefs.getStringList("Preview.contentTypes");
        int n = 0;
        while (n < stringArray.length) {
            if (string.startsWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void run() {
        try {
            int n;
            byte[] byArray = new byte[8192];
            byte[] byArray2 = new byte[]{0};
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = this.in.read(byArray, 0, byArray.length)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            Frame frame = this.factory.previewFrame;
            synchronized (frame) {
                PreviewDialog previewDialog = new PreviewDialog(this.factory.previewFrame, this.request, this.reply, byteArrayOutputStream.toByteArray());
                previewDialog.show();
                if (previewDialog.accept()) {
                    byArray2 = previewDialog.getContent();
                }
                previewDialog.dispose();
            }
            this.out.write(byArray2, 0, byArray2.length);
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

