/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import muffin.Filter;
import muffin.FilterFactory;
import muffin.FilterManager;
import muffin.Prefs;
import muffin.filter.GlossaryFilter;
import muffin.filter.GlossaryFrame;

public class Glossary
extends Hashtable
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    GlossaryFrame frame;

    public Glossary() {
        super(33);
    }

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        String string = prefs.getUserFile("glossary");
        prefs.putString("Glossary.glossaryfile", string);
        prefs.setOverride(bl);
        this.load();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new GlossaryFrame(this.prefs, this);
        }
        ((Component)this.frame).setVisible(true);
    }

    public Filter createFilter() {
        GlossaryFilter glossaryFilter = new GlossaryFilter(this);
        glossaryFilter.setPrefs(this.prefs);
        return glossaryFilter;
    }

    void save() {
        this.manager.save(this);
    }

    String lookup(String string) {
        return (String)this.get(string.toLowerCase());
    }

    void load() {
        String string = this.prefs.getString("Glossary.glossaryfile");
        System.out.println("Glossary loading " + string);
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("Glossary can't open " + string);
            return;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                this.put(string3.toLowerCase(), string4);
            }
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

