/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.net.URL;

public class ImageCanvas
extends Canvas {
    private Image image;
    private Color bg;
    private boolean border = false;

    public ImageCanvas(String string, Color color, boolean bl) {
        try {
            MediaTracker mediaTracker = new MediaTracker(this);
            URL uRL = this.getClass().getResource(string);
            if (uRL != null) {
                this.image = Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
                mediaTracker.addImage(this.image, 1);
                mediaTracker.waitForAll();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.bg = color;
        this.border = bl;
        if (color != null) {
            this.setBackground(color);
        }
    }

    public ImageCanvas(Image image) {
        this.image = image;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public Dimension getPreferredSize(int n) {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public Dimension getMinimumSize(int n) {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, this);
        }
        if (this.border) {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.image.getWidth(this) - 1, this.image.getHeight(this) - 1);
        }
    }
}

