/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TimeZone;
import muffin.FilterFactory;
import muffin.FilterManager;
import muffin.HttpError;
import muffin.HttpRelay;
import muffin.Options;
import muffin.Prefs;
import muffin.Reply;
import muffin.Request;

class Httpd
extends HttpRelay {
    static Options options = null;
    static FilterManager manager = null;
    Socket socket;
    Request request;

    Httpd(Socket socket) {
        this.socket = socket;
    }

    public void write(Request request) throws IOException {
        this.request = request;
    }

    String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '+') {
                stringBuffer.append(" ");
            } else if (c == '%') {
                try {
                    int n2 = Integer.parseInt(string.substring(n + 1, n + 3), 16);
                    stringBuffer.append((char)n2);
                }
                catch (Exception exception) {}
                n += 2;
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    String getDateString() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance();
        simpleDateFormat.applyPattern("EEE, dd MMM yyyy HH:mm:ss z");
        TimeZone timeZone = TimeZone.getDefault();
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = simpleDateFormat.format(new Date());
        return string;
    }

    String getInfo() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<title>Muffin Admin</title><body>\n");
        stringBuffer.append("<h1>Muffin ");
        stringBuffer.append(options.get("muffin.version"));
        stringBuffer.append(" on " + options.get("muffin.host") + " port " + options.get("muffin.port"));
        stringBuffer.append("</h1>\n");
        stringBuffer.append("<hr>\n");
        stringBuffer.append("<table><tr><td>\n");
        stringBuffer.append("<a name=\"Known Filters\"><h1>Known Filters</h1></a>\n");
        stringBuffer.append("<form method=POST action=/bin/enable>\n");
        stringBuffer.append("<select size=10 name=filter>\n");
        int n = 0;
        while (n < Httpd.manager.knownFilters.size()) {
            stringBuffer.append("<option>" + (String)Httpd.manager.knownFilters.elementAt(n) + "\n");
            ++n;
        }
        stringBuffer.append("</select>\n");
        stringBuffer.append("<br><input type=submit value=Enable>\n");
        stringBuffer.append("</form>\n");
        stringBuffer.append("</td><td>\n");
        stringBuffer.append("<a name=\"Enabled Filters\"><h1>Enabled Filters</h1></a>\n");
        stringBuffer.append("<form method=POST action=/bin/disable>\n");
        stringBuffer.append("<select size=10 name=index>\n");
        int n2 = 0;
        while (n2 < Httpd.manager.enabledFilters.size()) {
            FilterFactory filterFactory = (FilterFactory)Httpd.manager.enabledFilters.elementAt(n2);
            object = filterFactory.getClass().getName();
            stringBuffer.append("<option value=" + n2 + ">" + (String)object + "\n");
            ++n2;
        }
        stringBuffer.append("</select>\n");
        stringBuffer.append("<br>");
        stringBuffer.append("<input type=submit value=Disable>\n");
        stringBuffer.append("</form>\n");
        stringBuffer.append("</td></tr></table>\n");
        int n3 = 0;
        while (n3 < Httpd.manager.enabledFilters.size()) {
            object = (FilterFactory)Httpd.manager.enabledFilters.elementAt(n3);
            String string = object.getClass().getName();
            Prefs prefs = object.getPrefs();
            stringBuffer.append("<hr>\n");
            stringBuffer.append("<a name=\"" + string + "\"><h1>" + string + "</h1></a>\n");
            if (prefs.isEmpty()) {
                stringBuffer.append("No Preferences.\n");
            } else {
                stringBuffer.append("<form method=POST action=/bin/set>\n");
                stringBuffer.append("<input type=hidden name=filter value=\"" + string + "\">\n");
                stringBuffer.append("<table>\n");
                Enumeration enumeration = prefs.sortedKeys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)prefs.get(string2);
                    stringBuffer.append("<tr><td>" + string2 + "</td>");
                    stringBuffer.append("<td><input name=\"" + string2 + "\" size=" + string3.length() + " type=text value=\"" + string3 + "\"></input></td></tr>\n");
                }
                stringBuffer.append("</table>\n");
                stringBuffer.append("<br><input type=submit value=Submit><input type=reset value=Reset>\n");
                stringBuffer.append("</form>\n");
            }
            ++n3;
        }
        stringBuffer.append("<hr>\n");
        stringBuffer.append("<a name=\"Virtual Machine\"><h1>Virtual Machine</h1></a>\n");
        stringBuffer.append("<table>\n");
        stringBuffer.append("<tr><td>java.version</td><td>" + System.getProperty("java.version") + "</td></tr>\n");
        stringBuffer.append("<tr><td>java.class.version</td><td>" + System.getProperty("java.class.version") + "</td></tr>\n");
        stringBuffer.append("<tr><td>java.class.path</td><td>" + System.getProperty("java.class.path") + "</td></tr>\n");
        stringBuffer.append("<tr><td>java.home</td><td>" + System.getProperty("java.home") + "</td></tr>\n");
        stringBuffer.append("<tr><td>java.vendor</td><td>" + System.getProperty("java.vendor") + "</td></tr>\n");
        stringBuffer.append("<tr><td>os.version</td><td>" + System.getProperty("os.version") + "</td></tr>\n");
        stringBuffer.append("<tr><td>os.arch</td><td>" + System.getProperty("os.arch") + "</td></tr>\n");
        stringBuffer.append("<tr><td>os.name</td><td>" + System.getProperty("os.name") + "</td></tr>\n");
        stringBuffer.append("<tr><td>user.name</td><td>" + System.getProperty("user.name") + "</td></tr>\n");
        stringBuffer.append("<tr><td>user.dir</td><td>" + System.getProperty("user.dir") + "</td></tr>\n");
        stringBuffer.append("<tr><td>user.home</td><td>" + System.getProperty("user.home") + "</td></tr>\n");
        stringBuffer.append("</table>\n");
        stringBuffer.append("</body>\n");
        return stringBuffer.toString();
    }

    public Reply read() throws IOException {
        Reply reply = new Reply();
        reply.setHeaderField("Server", "Muffin/" + options.getString("muffin.version"));
        reply.setHeaderField("Date", this.getDateString());
        if (this.request.getPath().startsWith("/images/")) {
            String string = this.request.getPath().substring(1);
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            reply.statusLine = "HTTP/1.0 200 Ok";
            reply.setHeaderField("Content-type", "image/jpeg");
            this.in = inputStream;
        } else if (!options.adminAccess(this.socket.getInetAddress())) {
            HttpError httpError = new HttpError(options, 403, "Administrative access denied");
            reply = httpError.getReply();
            this.in = new ByteArrayInputStream(httpError.getContent().getBytes());
        } else if (this.request.getPath().equals("/")) {
            byte[] byArray = this.getInfo().getBytes();
            reply.statusLine = "HTTP/1.0 200 Ok";
            reply.setHeaderField("Content-type", "text/html");
            reply.setHeaderField("Content-length", Integer.toString(byArray.length));
            this.in = new ByteArrayInputStream(byArray);
        } else if (this.request.getPath().startsWith("/images/")) {
            String string = this.request.getPath().substring(1);
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            reply.statusLine = "HTTP/1.0 200 Ok";
            reply.setHeaderField("Content-type", "image/gif");
            this.in = inputStream;
        } else if (this.request.getPath().equals("/bin/enable")) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(this.decode(this.request.getData()), "&");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                String string = ((String)object).substring(0, ((String)object).indexOf(61));
                String string2 = ((String)object).substring(((String)object).indexOf(61) + 1);
                if (!string.equals("filter")) continue;
                manager.enable(string2);
            }
            reply.statusLine = "HTTP/1.0 302 Moved Temporarily";
            reply.setHeaderField("Location", String.valueOf(Httpd.getLocation()) + "/");
            object = new String("Document Moved").getBytes();
            this.in = new ByteArrayInputStream((byte[])object);
        } else if (this.request.getPath().equals("/bin/disable")) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(this.decode(this.request.getData()), "&");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                String string = ((String)object).substring(0, ((String)object).indexOf(61));
                String string3 = ((String)object).substring(((String)object).indexOf(61) + 1);
                if (!string.equals("index")) continue;
                try {
                    int n = Integer.parseInt(string3);
                    manager.disable(n);
                }
                catch (Exception exception) {}
            }
            reply.statusLine = "HTTP/1.0 302 Moved Temporarily";
            reply.setHeaderField("Location", String.valueOf(Httpd.getLocation()) + "/");
            object = new String("Document Moved").getBytes();
            this.in = new ByteArrayInputStream((byte[])object);
        } else if (this.request.getPath().equals("/bin/set")) {
            Object object;
            FilterFactory filterFactory = null;
            StringTokenizer stringTokenizer = new StringTokenizer(this.decode(this.request.getData()), "&");
            block4: while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                String string = ((String)object).substring(0, ((String)object).indexOf(61));
                String string4 = ((String)object).substring(((String)object).indexOf(61) + 1);
                if (string.equals("filter")) {
                    int n = 0;
                    while (n < Httpd.manager.enabledFilters.size()) {
                        FilterFactory filterFactory2 = (FilterFactory)Httpd.manager.enabledFilters.elementAt(n);
                        String string5 = filterFactory2.getClass().getName();
                        if (string5.equals(string4)) {
                            filterFactory = filterFactory2;
                            continue block4;
                        }
                        ++n;
                    }
                    continue;
                }
                if (filterFactory == null) continue;
                Prefs prefs = filterFactory.getPrefs();
                prefs.put(string, string4);
            }
            reply.statusLine = "HTTP/1.0 302 Moved Temporarily";
            reply.setHeaderField("Location", String.valueOf(Httpd.getLocation()) + "/");
            object = new String("Document Moved").getBytes();
            this.in = new ByteArrayInputStream((byte[])object);
        } else {
            HttpError httpError = new HttpError(options, 404, String.valueOf(this.request.getPath()) + " not found");
            reply = httpError.getReply();
            this.in = new ByteArrayInputStream(httpError.getContent().getBytes());
        }
        return reply;
    }

    static void init(Options options, FilterManager filterManager) {
        Httpd.options = options;
        manager = filterManager;
    }

    static boolean sendme(Request request) {
        return request.getHost().equalsIgnoreCase(options.getString("muffin.host")) && request.getPort() == options.getInteger("muffin.port");
    }

    static String getLocation() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("http://");
        stringBuffer.append(options.getString("muffin.host"));
        stringBuffer.append(":");
        stringBuffer.append(options.getString("muffin.port"));
        return stringBuffer.toString();
    }
}

