/* Monitor.java */

/* 
 * Copyright (C) 1996 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package muffin;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * @author Mark Boyns
 */
public class Monitor extends Canvas
{
    Vector handlers;
    Font font;
    FontMetrics fontMetrics;
    boolean suspended = false;

    Hashtable colorTable;
    
    public Monitor ()
    {
	handlers = new Vector (100);

	setBackground (Color.lightGray);

	font = new Font ("Helvetica", Font.BOLD, 10);
	fontMetrics = getFontMetrics (font);
	setFont (font);

	colorTable = new Hashtable ();
	colorTable.put ("text/html", Color.cyan);
	colorTable.put ("text/plain", Color.cyan);
	
	colorTable.put ("image/gif", Color.green);
	colorTable.put ("image/jpeg", Color.green);
	colorTable.put ("image/jpeg", Color.green);
	colorTable.put ("image/tiff", Color.green);
	colorTable.put ("image/x-png", Color.green);

	colorTable.put ("audio/basic", Color.orange);
	colorTable.put ("audio/x-wav", Color.orange);
	colorTable.put ("audio/x-aiff", Color.orange);
	colorTable.put ("audio/x-realaudio", Color.orange);
	
	colorTable.put ("default", Color.white);
    }

    void register (Handler h)
    {
	handlers.addElement (h);
	repaint ();
    }

    void unregister (Handler h)
    {
	handlers.removeElement (h);
	repaint ();
    }
    
    void update (Handler h)
    {
	repaint ();
    }

    void suspend ()
    {
	suspended = true;
	repaint ();
    }

    void resume ()
    {
	suspended = false;
	repaint ();
    }

    public Dimension preferredSize ()
    {
	return minimumSize ();
    }

    public Dimension minimumSize ()
    {
	return new Dimension (200, 150);
    }
    
    public void paint (Graphics g)
    {
	Insets insets = new Insets (5, 5, 5, 5);
	Dimension d = size ();

	if (suspended)
	{
	    g.setColor (Color.gray);
	    g.fillRect (2, 2, d.width-4, d.height-4);
	    return;
	}
	
	g.setColor (Color.lightGray);
	g.draw3DRect (2, 2, d.width-4, d.height-4, false);
	
	int y = insets.top;
	
	Enumeration e = handlers.elements ();
 	while (e.hasMoreElements ())
 	{
	    Object obj = e.nextElement ();
 	    Handler handler = (Handler) obj;
	    
	    int currentBytes = handler.getCurrentBytes ();
	    int totalBytes = handler.getTotalBytes ();
	    int meterLength = 0;
	    int meterMax = d.width - insets.left - insets.right;
	    String contentType = null;
	    StringBuffer buf = new StringBuffer ();

	    if (handler.reply != null)
	    {
		contentType = handler.reply.getHeaderField ("Content-type");
		buf.append (contentType);
		buf.append (" ");
		if (totalBytes > 0)
		{
		    double percentComplete = (double)currentBytes/totalBytes;
		    meterLength = (int)(percentComplete*meterMax);
		    buf.append ((int)(percentComplete*100));
		    buf.append ("% of ");
		    buf.append (totalBytes/1024);
		    buf.append ("k");
		}
		else
		{
		    buf.append (currentBytes/1024);
		    buf.append ("k");
		}
	    }
	    else
	    {
		buf.append ("Contacting ");
		buf.append (handler.request.getHost ());
		buf.append ("...");
	    }

	    int h = fontMetrics.getHeight ();

	    g.setColor ((Color) colorTable.get (contentType != null ? contentType : "default"));
	    g.fillRect (insets.left, y, meterLength, h);
	    g.setColor (Color.black);
	    g.drawRect (insets.left, y, meterMax, h);
	    g.drawString (buf.toString (), insets.left + 10, y+h-fontMetrics.getMaxDescent ());
	    y += h + 5;
	}
    }
}
