/* Icon.java */

/* 
 * Copyright (C) 1996 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;

class Icon extends java.awt.Canvas
{
    boolean raised = true;
    Image icon = null;
    
    Icon ()
    {
	icon = Toolkit.getDefaultToolkit().getImage ("images/mufficon.gif");
    }
    
    public Dimension preferredSize ()
    {
	return new Dimension (36, 36);
    }

    public Dimension preferredSize (int rows)
    {
	return new Dimension (36, 36);
    }

    public Dimension minimumSize ()
    {
	return new Dimension (36, 36);
    }

    public Dimension minimumSize (int rows)
    {
	return new Dimension (36, 36);
    }

    public boolean mouseDown (Event e, int x, int y)
    {
	raised = false;
	repaint ();
	return true;
    }
    
    public boolean mouseUp (Event e, int x, int y)
    {
	raised = true;
	repaint ();
	return true;
    }
    
    public void paint (Graphics g)
    {
	g.setColor (Color.lightGray);
	for (int i = 0; i < 2; i++)
	{
	    g.draw3DRect (i, i, 36 - i*2, 36 - i*2, raised);
	}
	if (raised)
	{
	    g.drawImage (icon, 2, 2, this);
	    g.setColor (Color.lightGray);
	    g.drawRect (2, 2, 32, 32);
	}
	else
	{
	    g.drawImage (icon, 3, 3, 31, 31, this);
	}
    }
}
