/* About.java */

/* 
 * Copyright (C) 1996 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

/**
 * @author Mark Boyns
 */
public class About extends Frame
{
    public About (String version)
    {
	super ("About Muffin");

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
	GridBagConstraints c;
	Label l;
	panel.setLayout (layout);
	panel.setBackground (Color.white);

 	l = new Label ("Muffin");
 	l.setFont (new Font ("Helvetica", Font.BOLD, 24));
 	c = new GridBagConstraints ();
 	c.gridwidth = GridBagConstraints.REMAINDER;
 	layout.setConstraints (l, c);
 	panel.add (l);

	l = new Label ("version " + version);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);
	
	l = new Label ("by Mark Boyns <boyns@sdsu.edu>");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.gridheight = 5;
	layout.setConstraints (l, c);
	panel.add (l);
	
	l = new Label ("Computer Development Research Group");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);

	ImageCanvas sdsu = new ImageCanvas ("images/sdsu.gif", null, false);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (sdsu, c);
	panel.add (sdsu);
	
	l = new Label ("San Diego State University");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.insets = new Insets (0, 0, 0, 0);
	layout.setConstraints (l, c);
	panel.add (l);
	
	ImageCanvas logo = new ImageCanvas ("images/muffin.gif", null, false);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (logo, c);
	panel.add (logo);

	l = new Label ("Graphics: Rebecca Smith <rsmith@rohan.sdsu.edu>");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);
	
	l = new Label ("More information is available here:");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);
	
	l = new Label ("http://www.sdsu.edu/~boyns/java/muffin/");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);
	
	add ("Center", panel);
	add ("South", new Button ("OK"));

	pack ();
	resize (preferredSize ());
	
	show ();
    }

    public boolean action (Event event, Object arg)
    {
	if (event.target instanceof Button)
	{
	    if ("OK".equals (arg))
	    {
		hide ();
	    }
	    return true;
	}
	return false;
    }
}
