Summary: Interactively creates a Linux packet filtering firewall.
Name: mason
Version: 0.13.0
Release: 1
Copyright: GPL
Group: Utilities/Network
Source: http://www.pobox.com/~wstearns/mason/mason-0.13.0.tar.gz
URL: http://www.pobox.com/~wstearns/mason/index.html
Vendor: William Stearns
Packager: William Stearns <wstearns@pobox.com>

%description
Mason creates a firewall that exactly matches the types of 
TCP/IP traffic flowing in, out and through a Linux computer.
It can be used to create a full firewall or add rules to an
existing firewall.

%prep
%setup

%build

%install
make install

%files
%doc COPYING Quickstart index.html mason.lsm mason.txt overview protocols.txt
%attr(600,root,root) %config	/etc/masonrc
%attr(755,root,root)			/etc/rc.d/init.d/firewall
%attr(755,root,root)			/usr/bin/mason
%attr(755,root,root)			/usr/bin/mason-gui-text
%attr(644,root,root)			/usr/man/man1/mason.1
%attr(644,root,root)			/usr/man/man1/mason-gui-text.1
%attr(755,root,root) %dir		/var/lib/mason
%attr(755,root,root)			/var/lib/mason/baserules.sample
%attr(755,root,root)			/var/lib/mason/masonlib
%attr(755,root,root)			/var/lib/mason/moreservices
%attr(755,root,root)			/var/lib/mason/nmap-services

%pre
if [ -f /etc/masonrc ]; then
	rm -f /etc/masonrc.oldversion
	cp -pf /etc/masonrc /etc/masonrc.oldversion
fi

%post
if [ ! -f /var/lib/mason/baserules ]; then
	cp -p /var/lib/mason/baserules.sample /var/lib/mason/baserules
	chown root.root /var/lib/mason/baserules
	chmod 700 /var/lib/mason/baserules
fi

if [ ! -f /var/lib/mason/newrules ]; then
	touch /var/lib/mason/newrules
	chown root.root /var/lib/mason/newrules
	chmod 700 /var/lib/mason/newrules
fi

if [ -f /etc/masonrc.oldversion ]; then
	cat /etc/masonrc.oldversion | grep -v '^#' | grep -v '^$' >>/etc/masonrc
	rm -f /etc/masonrc.oldversion
	echo "NOTE - your old settings have been appended to the end of the " >>/etc/masonrc.README
	echo "new /etc/masonrc." >>/etc/masonrc.README
fi

