#!/usr/bin/perl -w

# gforward.pl v0.01
# a generic forwarding tool for
# iptables.  Part of the gShield
# firewall. Licensed under the GPL
# godot@linuxmafia.org

# gforward is a perl script which quickly
# generates basic port-forwarding mechanisms
# using iptables.

# usage ditty
sub usage() {
      print <<DUMP
Usage: gforward.pl [external interface ][firewall port] [destination ip] [destination port]
----------------
Example: (forward port 80 to machine 192.168.1.6, port 80 and run the ruleset)
gforward.pl eth0 80 192.168.1.6 80 > test.rules && sh test.rule

Example: (gShield users) 
gforward.pl eth0 80 192.168.1.6 80 >> /etc/firewall/gshield.last && /etc/firewall/gShield.rc
DUMP
;
}

# make syre options hae been passed
if ( $#ARGV < 3 ) {
      &usage(); exit;
}

# map given variables
($EXTERNAL, $FW_PORT, $DEST_IP, $DEST_PORT) = ($ARGV[0], $ARGV[1], $ARGV[2], $ARGV[3]);

# set and map variables / sanity check on options
die "Cannot determine path to iptables: set manually" unless (chomp($iptables = `which iptables`));
die "Error: Invalid port\n" while (($DEST_PORT|$FW_PORT)  =~ /\D/) || (($DEST_PORT|$FW_PORT) < 1) || (($DEST_PORT|$FW_PORT) > 65535);

# output
print "$iptables -I FORWARD -p tcp -d $DEST_IP --dport $DEST_PORT -j ACCEPT\n",      
	  "$iptables -I FORWARD -p udp -d $DEST_IP --dport $DEST_PORT -j ACCEPT\n", 
	  "$iptables -t nat -A PREROUTING -p tcp -i $EXTERNAL --dport $FW_PORT -j DNAT --to $DEST_IP:$DEST_PORT\n", 
	  "$iptables -t nat -A PREROUTING -p udp -i $EXTERNAL --dport $FW_PORT -j DNAT --to $DEST_IP:$DEST_PORT\n";   
