#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "testxdr.c,v 1.1.1.1 1995/06/16 17:42:47 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test XDR routines
 */

#include "sos.h"

int tint;
long tlong;
short tshort;
char *tstring;
sos_string tbuffer;
char tchar;
int port=2332;

void client(char *);
void server();


main(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int c;

  
  while ((c = getopt(argc, argv, "rt:p:")) != -1)
    switch (c)
      {
      case 'r':
	server();
	break;

      case 't':
	client(optarg);
	break;

      case 'p':
	port = atoi(optarg);
	break;       

      default :
	printf("Usage: %s -r|-t server\n",argv[0]);
	exit(1);
	break;
      }
  exit(0);
}


void
client(char *server)
{
  int s;			/* socket */
  struct sockaddr_in saddr;	/* Server addr */
  struct hostent *servhent;	/* Hostent */
  int i;			/* Dumb counter */


  tint = 2323;
  tlong = -17;
  tshort = 124;
  tstring = strdup("This is a null terminated test string");
  tbuffer.len = 1024;
  tchar = '[';

#if 0
  srandom (getpid());
#endif
  tbuffer.str = (char *)malloc(tbuffer.len);
  for (i=1; i <= 1021; i++)
    tbuffer.str[i]=(char)((i%64)+64);
#if 0
    tbuffer.str[i]=(char)rint((double)random() / (double)MAXLONG * 256.0);
#endif
  tbuffer.str[0]='*';
  tbuffer.str[1021]='%';
  tbuffer.str[1022]='*';
  tbuffer.str[1023]='/';


  /* NO ERROR CHECKING !! :-) */
  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror("socket");
      exit(5);
    }

  servhent = sos_gethbyfoo(server);

  memset ((char *)&saddr, (char)0, sizeof(saddr));
  saddr.sin_family = AF_INET;
  saddr.sin_port = htons (port);
  memcpy((caddr_t)&(saddr.sin_addr.s_addr),
	 (caddr_t)(servhent->h_addr_list[0]),
	 sizeof(servhent->h_addr_list[0]));

  if ((connect(s, (struct sockaddr *)&saddr, sizeof(saddr))) < 0)
    {
      perror("connect");
      exit(5);
    }

  if ( sos_xdr_wencode(s, sosBIOwrite, "ilsScB", 
		       tint, 
		       tlong, 
		       tshort,
		       tstring, 
		       tchar,
		       &tbuffer
		       ) == -1 ) 
    {
      fprintf(stderr,"client: sos_xdr_wencode() failed\n");
      return;
    }

  (void)sos_xdr_freebuf();
  return;
}


void
server()
{

  int s;			/* Socket */
  int child;			/* Socket */
  struct sockaddr_in sock;	/* My name. */
  int len;			/* Length of socket */
  int foo;
    
  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror("socket");
      exit(5);
    }

  len = sizeof (sock);
  memset((char *)&sock, (char )0, sizeof(sock));
  sock.sin_family = htons(AF_INET);
  sock.sin_port = htons (port);
  sock.sin_addr.s_addr = INADDR_ANY;

  if (bind (s, (struct sockaddr *)&sock, len) < 0)
    {
      perror("bind");
      exit(5);
    }

  if (listen(s, 5) < 0)
    {
      perror("bind");
      exit(5);
    }

  memset((char *)&sock, (char )0, sizeof(sock));
  if ((child  = accept (s, (struct sockaddr *)&sock, (int *)&len)) < 0)
    {
      perror("bind");
      exit(5);
    }
  fprintf(stderr,"Acceptance is nice\n");

  if ((foo = sos_xdr_wdecode(child, sosBIOread, "ilsScB", 
		       &tint, 
		       &tlong, 
		       &tshort,
		       &tstring, 
		       &tchar,
		       &tbuffer
			     )) != 6 ) 
    {
      fprintf(stderr,"server: sos_xdr_wdecode(%d) failed\n",foo);
      return;
    }

  printf("*********** Server output *************\n");
  printf("Int: %d\nLong: %d\nShort: %d\nString: **%s**\nBuffer(%d): **%s**\nChar: %c\n",
		       tint, 
		       tlong, 
	 	       tshort,
		       tstring, 
		       tbuffer.len,
		       tbuffer.str,
		       tchar);

  (void)sos_xdr_freebuf();
  return;
  
}
