#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "testskid.c,v 1.1.1.1 1995/06/16 17:42:46 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test the new SKID3 protocol
 */

#include "sos.h"

int port=2332;

int client(char *);
int server();

extern int sos_skid_trace;
sos_config_t config;


main(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int c;
  int ret = -2;

  config = sos_config_read(SOS_ENV_GWD("BS_RMNT_CONF","/etc/bs.rmnt.conf"));
  
  while ((c = getopt(argc, argv, "vrt:p:")) != -1)
    switch (c)
      {
      case 'r':
	ret = server();
	break;

      case 't':
	ret = client(optarg);
	break;

      case 'p':
	port = atoi(optarg);
	break;       

      case 'v':	
	sos_skid_trace = 1;
	break;

      default :
	printf("Usage: %s [-v] [-p <port>] -r|-t server\n",argv[0]);
	exit(1);
	break;
      }

  if (ret == 0)
    printf("SKID LOST!!!\n");
  else if (ret == 1)
    printf("SKID WON!!!\n");
  else if (ret == -1)
    printf("SKID ERROR!!!\n");
  else
    printf("WHAT THE !$*%% IS GOING ON??? (%d)\n",ret);

  exit(0);
}


int
client(char *server)
{
  int s;			/* socket */
  struct sockaddr_in saddr;	/* Server addr */
  struct hostent *servhent;	/* Hostent */

  /* NO ERROR CHECKING !! :-) */
  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror("socket");
      exit(5);
    }

  servhent = sos_gethbyfoo(server);

  memset ((char *)&saddr, (char)0, sizeof(saddr));
  saddr.sin_family = AF_INET;
  saddr.sin_port = htons (port);
  memcpy((caddr_t)&(saddr.sin_addr.s_addr),
	 (caddr_t)(servhent->h_addr_list[0]),
	 sizeof(servhent->h_addr_list[0]));

  if ((connect(s, (struct sockaddr *)&saddr, sizeof(saddr))) < 0)
    {
      perror("connect");
      exit(5);
    }

  return(sos_skid(s, sos_config_getnext(config, "authkey", SOS_CONFIG_FORWARD, SOS_CONFIG_STATIC), sosBIOread, sosBIOwrite));
}


int
server()
{

  int s;			/* Socket */
  int child;			/* Socket */
  struct sockaddr_in sock;	/* My name. */
  int len;			/* Length of socket */
    
  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror("socket");
      exit(5);
    }

  len = sizeof (sock);
  memset((char *)&sock, (char )0, sizeof(sock));
  sock.sin_family = AF_INET;
  sock.sin_port = htons (port);
  sock.sin_addr.s_addr = INADDR_ANY;

  if (bind (s, (struct sockaddr *)&sock, len) < 0)
    {
      perror("bind");
      exit(5);
    }

  if (listen(s, 5) < 0)
    {
      perror("bind");
      exit(5);
    }

  memset((char *)&sock, (char )0, sizeof(sock));
  if ((child  = accept (s, (struct sockaddr *)&sock, (int *)&len)) < 0)
    {
      perror("bind");
      exit(5);
    }
  fprintf(stderr,"Acceptance is nice\n");
  close(s);

  return(sos_skid(child, sos_config_getnext(config, "authkey", SOS_CONFIG_FORWARD, SOS_CONFIG_STATIC), sosBIOread, sosBIOwrite));
}
