#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "testneg.c,v 1.1.1.1 1995/06/16 17:42:46 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 *
 * Test option negotiation
 *
 */


#include "sos.h"

extern int sos_negotdebug;

#define READ 0
#define WRITE 1

/* BS -- remote config file handle */
extern sos_config_t bs_auth_config;

main(int argc, char *argv[])
{
  
  char *config_file;
  sos_config_t bs_auth_config;  
  int p2c[2];
  int c2p[2];
  int retval;

  config_file=strdup( SOS_ENV_GWD("BS_RMNT_CONF","/etc/bs.rmnt.conf"));
  bs_auth_config=sos_config_read(config_file);
  sos_opt_config_predisp(bs_auth_config, "option");
  
  pipe(p2c);
  pipe(c2p);

  if  ( fork() )
    {
      /* parent */
      close(p2c[READ]);
      close(c2p[WRITE]);
      sos_negotdebug=0;
      retval = sos_negotiate_options(c2p[READ],
				     (int (*)(int, caddr_t, __SIZE_TYPE__))read, 
				     p2c[WRITE],
				     (int (*)(int, caddr_t, __SIZE_TYPE__))write);
      if ( retval <  0 )
	printf("Parent: Negotiation failure or incompatible prferences\n");
      exit (0);

    }
  
  close(p2c[WRITE]);
  close(c2p[READ]);
  retval = sos_negotiate_options(p2c[READ],
				  (int (*)(int, caddr_t, __SIZE_TYPE__))read, 
				  c2p[WRITE],
				  (int (*)(int, caddr_t, __SIZE_TYPE__))write);
  
    if ( retval <  0 )
      printf("Child: Negotiation failure or incompatible prferences\n");

  printf("testneg: Printing results from child\n");
  sos_opt_print_opts();

  exit(0);
}
