#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "testfair.c,v 1.1.1.1 1995/06/16 17:42:46 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 *
 * Test fairtossing
 *
 */


#include "sos.h"

#define READ 0
#define WRITE 1

main(int argc, char *argv[])
{

  int p2c[2];
  int c2p[2];
  int retval;
  extern int sos_fairdebug;

  pipe(p2c);
  pipe(c2p);

  if  ( fork() )
    {
      /* parent */
      close(p2c[READ]);
      close(c2p[WRITE]);
      retval = sos_fairtoss_win_lose(c2p[READ],
			    (int (*)(int, caddr_t, __SIZE_TYPE__))read, 
			    p2c[WRITE],
			    (int (*)(int, caddr_t, __SIZE_TYPE__))write);
      switch (retval)
	{
	case -1:
	  printf("Parent: Fairtoss error\n");
	  break;
	  
	case SOS_FAIRTOSS_WIN:
	  printf("Parent: WIN\n");
	  break;

	case SOS_FAIRTOSS_LOSE:
	  printf("Parent: LOSE\n");
	  break;
	  
	default:
	  printf("Parent: Weird return val: %d\n", retval);
	  break;
	}
      exit (1);
    }
  
  close(p2c[WRITE]);
  close(c2p[READ]);
  sos_fairdebug=0;
  retval= sos_fairtoss_win_lose(p2c[READ],
		       (int (*)(int, caddr_t, __SIZE_TYPE__))read, 
			c2p[WRITE],
			(int (*)(int, caddr_t, __SIZE_TYPE__))write);
  switch (retval)
    {
    case -1:
      printf("Child: Fairtoss error\n");
      break;
      
    case SOS_FAIRTOSS_WIN:
      printf("Child: WIN\n");
      break;
      
    case SOS_FAIRTOSS_LOSE:
      printf("Child: LOSE\n");
      break;
	  
    default:
      printf("Child: Weird return val: %d\n", retval);
      break;
    }
  exit (1);
  
}
