#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "testProcTitle.c,v 1.1.1.1 1995/06/16 17:42:45 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test the ProcTitle routines
 */

#include "sos.h"

char *program;
void PrintInfo(int argc, char *argv[], char *envp[]);


main(int argc, char *argv[], char **envp)
{
  int c;
  int ret = -2;
  char cmd[80];

  PrintInfo(argc, argv, envp);
  fflush(stdout);
  system(cmd);
  fflush(stdout);

  if (sos_initProcTitle(argc, &argv, &envp, &program) < 0)
    {
      perror("init ProcTitle");
      exit(2);
    }

#if 0
  sprintf(cmd, "sps wep %d", getpid());
#else
  sprintf(cmd, "ps xwwwp %d", getpid());
#endif


  PrintInfo(argc, argv, envp);
  fflush(stdout);
  system(cmd);
  fflush(stdout);

#if 0
  sos_setProcTitle("User seth, Dhost dauntless.soscorp.com, Shost sirius.ctr.columbia.edu, pid %d ", getpid());
#else
  sos_setProcTitle("12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
#endif
  fflush(stdout);
  PrintInfo(argc, argv, envp);
  fflush(stdout);
  system(cmd);
  fflush(stdout);

  printf("\n\nPRINTENV\n--------------------------------------------------\n");
  fflush(stdout);

  system("/usr/ucb/printenv");

  exit(0);
}


void PrintInfo(int argc, char *argv[], char *envp[])
{
  int c;

  printf("\n\nProgram %s\n\nARGV\n--------------------------------------------------\n", program);

  for(c=0;c<argc;c++)
    {
      printf("argv[%02d] = %s\n", c, argv[c]);
    }

  printf("\nENVP\n--------------------------------------------------\n");

  for(c=0;envp[c];c++)
    {
      printf("envp[%03d] = %s\n", c, envp[c]);
    }
  printf("\n\n");
}
