#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "tty.c,v 1.1.1.1 1995/06/16 17:42:44 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Terminal handling stuff
 */

#include "sos.h"
#include <termios.h>



/*
 * Turn off echoing
 *
 * We turn off ECHO, but other flags, like ECHOE, ECHOK, and ECHONL, may be important
 *
 * Returns:	0  - not a tty
 *		1  - success
 *		-1 - error
 */
int 
sos_tty_echooff(int fd, struct termios *termsave)
{
  struct termios old;

  if (termsave)
    {
      memset((void *)termsave, 0, sizeof(struct termios));
    }

  if (!isatty(fd))
    {
      return(0);
    }

  if (tcgetattr(fd, &old) < 0)
    return(-1);

  if (termsave)
    {
      memcpy((void *)termsave, (void *)&old, sizeof(old));
    }

  old.c_lflag &= ~(ECHO);

  tcsetattr(fd, TCSANOW, &old);

  return(1);
}



/*
 * Turn on echoing
 *
 * We turn on ECHO, but other flags, like ECHOE, ECHOK, and ECHONL, may be important
 *
 * Returns:	0  - not a tty
 *		1  - success
 *		-1 - error
 */
int 
sos_tty_echoon(int fd, struct termios *termsave)
{
  struct termios old;

  if (termsave)
    {
      memset((void *)termsave, 0, sizeof(struct termios));
    }

  if (!isatty(fd))
    {
      return(0);
    }

  if (tcgetattr(fd, &old) < 0)
    return(-1);

  if (termsave)
    {
      memcpy((void *)termsave, (void *)&old, sizeof(old));
    }

  old.c_lflag |= (ECHO);

  tcsetattr(fd, TCSANOW, &old);

  return(1);
}



/*
 * Turn off raw mode
 *
 * We turn off RAW
 *
 * Returns:	0  - not a tty
 *		1  - success
 *		-1 - error
 */
int 
sos_tty_rawoff(int fd, struct termios *termsave)
{
  struct termios old;

  if (termsave)
    {
      memset((void *)termsave, 0, sizeof(struct termios));
    }

  if (!isatty(fd))
    {
      return(0);
    }

  if (tcgetattr(fd, &old) < 0)
    return(-1);

  if (termsave)
    {
      memcpy((void *)termsave, (void *)&old, sizeof(old));
    }

  old.c_iflag |= (BRKINT|IGNPAR|ISTRIP|ICRNL|IXON);
  old.c_oflag |= (OPOST);
  old.c_lflag |= (ISIG|ICANON);
  if (VEOF == VMIN)
    old.c_cc[VEOF] = 4;
  if (VEOL == VTIME)
    old.c_cc[VEOL] = 0;

  tcsetattr(fd, TCSANOW, &old);

  return(1);
}



/*
 * Turn on raw mode
 *
 * We turn on RAW
 *
 * Returns:	0  - not a tty
 *		1  - success
 *		-1 - error
 */
int 
sos_tty_rawon(int fd, struct termios *termsave)
{
  struct termios old;

  if (termsave)
    {
      memset((void *)termsave, 0, sizeof(struct termios));
    }

  if (!isatty(fd))
    {
      return(0);
    }

  if (tcgetattr(fd, &old) < 0)
    return(-1);

  if (termsave)
    {
      memcpy((void *)termsave, (void *)&old, sizeof(old));
    }

  old.c_iflag &= ~(IGNBRK|BRKINT|IGNPAR|PARMRK|INPCK|ISTRIP|INLCR|IGNCR|ICRNL|IXON|IXOFF|IUCLC);
  old.c_oflag &= ~(OPOST);
  old.c_lflag &= ~(ISIG|ICANON);
  old.c_cc[VMIN] = 1;
  old.c_cc[VTIME] = 0;

  tcsetattr(fd, TCSANOW, &old);

  return(1);
}



/*
 * Set the termios to a particular value
 *
 * Returns:	0  - not a tty
 *		1  - success
 *		-1 - error
 */
int 
sos_tty_set(int fd, struct termios *termnew, struct termios *termsave)
{
  struct termios old;

  if (termsave)
    {
      memset((void *)termsave, 0, sizeof(struct termios));
    }

  if (!isatty(fd))
    {
      return(0);
    }

  if (tcgetattr(fd, &old) < 0)
    return(-1);

  if (termsave)
    {
      memcpy((void *)termsave, (void *)&old, sizeof(old));
    }

  tcsetattr(fd, TCSANOW, termnew);

  return(1);
}



/*
 * Get the termios to a particular value
 *
 * Returns:	0  - not a tty
 *		1  - success
 *		-1 - error
 */
int 
sos_tty_get(int fd, struct termios *termsave)
{
  struct termios old;

  if (termsave)
    {
      memset((void *)termsave, 0, sizeof(struct termios));
    }

  if (!isatty(fd))
    {
      return(0);
    }

  if (tcgetattr(fd, &old) < 0)
    return(-1);

  if (termsave)
    {
      memcpy((void *)termsave, (void *)&old, sizeof(old));
    }

  return(1);
}
