#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "sysinfo.c,v 1.1.1.1 1995/06/16 17:42:44 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Retrieve/set system information
 */

#include "sos.h"



/*
 * Find the current fd table size
 */
int sos_getdtablesize()
{
  struct rlimit rlimit;
  int tableSize;

  if (getrlimit(RLIMIT_NOFILE, &rlimit) == -1)
    {
      return(-1);
    }
  tableSize = rlimit.rlim_cur;

  return(tableSize);
}



/*
 * Set the current fd table size (returns old value)
 *
 * if (New < 0) New == max;
 */
int sos_setdtablesize(int new)
{
  struct rlimit rlimit;
  int oldtableSize;
  int maxtableSize;

  if (getrlimit(RLIMIT_NOFILE, &rlimit) == -1)
    {
      return(-1);
    }
  oldtableSize = rlimit.rlim_cur;
  maxtableSize = rlimit.rlim_max;

  if (new < 0)
    new = maxtableSize;

  rlimit.rlim_cur = new;

  if (setrlimit(RLIMIT_NOFILE, &rlimit) == -1)
    {
      return(-1);
    }

  return(oldtableSize);
}
