#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "string.c,v 1.1.1.1 1995/06/16 17:42:43 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Some string utilities (in both string and sos_string versions)
 *
 * Note: *tolower function seem to fail on some platforms
 * (BSDI 1.1) because tolower() does not work.  Go figure.
 */

#include <sos.h>

/* Convert strings to lowercase */
void
sos_strtolower(register char *s)
{
  sos_string ss;

  ss.str = s;
  ss.len = strlen(s);
  sos_sosstrtolower(&ss);
}

/* Convert strings to lowercase using sos_strings */
void
sos_sosstrtolower(sos_string *buf)
{
  register char *p, *start = buf->str;

  for(p = buf->str+buf->len-1;p>=start;p--)
    {
      *p=tolower(*p);
    }

  return;
}

/* Find location of s2 in s1 (slightly more efficient than BSD */
char *
sos_strstr(char *s1, char *s2)
{
  sos_string ss1, ss2;

  ss1.str = s1;
  ss1.len = strlen(s1);
  ss2.str = s2;
  ss2.len = strlen(s2);

  return(sos_sosstrstr(&ss1,&ss2));
}

/* strstr using sos_strings (does not need to be null terminated) */
char *
sos_sosstrstr(sos_string *s1, sos_string *s2)
{
  char *max = s1->str + s1->len - s2->len;
  register char *tmp;
  register char *dest = s2->str;
  register int dlen = s2->len;

  for(tmp=s1->str;tmp<=max;tmp++)
    {
      if (!strncmp(tmp,dest,dlen))
	return(tmp);
    }

  return(NULL);
}
