#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "rip.c,v 1.1.1.1 1995/06/16 17:42:43 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Terminate string at first CR or LF found
 *
 * (e.g. RIP off EOL)
 */

#include "sos.h"

#define RIP_CHARS "\r\n"


/* Turn first CR/LF found into a NULL */
char *sos_rip(char *x)
{
  char *ripped;

  if (!x) return(x);

  if (!(ripped = strpbrk(x,RIP_CHARS)))
    return(x);

  *ripped = '\0';
  return(x);
}


/*
 * Turn CRLF sequences into NULL or CRNULL
 */
char *sos_fixcrnl(char *x, int stripnl)
{
  char *nl;

  if (!x) return(x);

  for(nl = strchr(x,'\n');nl;nl = strchr(nl+1,'\n'))
    {
      if (nl > x && (*(nl-1) == '\r'))
	{
	  nl--;
	  if (!stripnl)
	    {
	      *(nl++) = '\n';
	    }
	  *(nl) = '\0';
	  break;
	}
    }

  return(x);
}
